package org.tiogasolutions.lib.spring.jersey;

import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.springframework.beans.factory.ListableBeanFactory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JerseySpringBridge extends AbstractBinder {

  private final List<Object> nonSpringObjects = new ArrayList<>();
  private final ListableBeanFactory beanFactory;

  public JerseySpringBridge(ListableBeanFactory beanFactory, Object... nonSpringObjects) {
    this.beanFactory = beanFactory;
    Collections.addAll(this.nonSpringObjects, nonSpringObjects);
  }

  @Override
  protected void configure() {

    for (Object object : nonSpringObjects) {
      bindFactory(new Factory<Object>() {
        @Override public void dispose(Object instance) {}
        @Override public Object provide() {
          return object;
        }
      }).to(object.getClass());
    }

    String[] beanNames = beanFactory.getBeanDefinitionNames();
    for (String beanName : beanNames) {

      Object bean = beanFactory.getBean(beanName);
      List<Class<?>> types = getAllTypes(bean);

      for (Class<?> type : types) {
        bindFactory(new Factory<Object>() {
            @Override public void dispose(Object instance) {}
            @Override public Object provide() {
              return bean;
            }
        }).to(type);
      }
    }
  }

  public List<Class<?>> getAllTypes(Object bean) {

    List<Class<?>> types = new ArrayList<>();

    Class<?> type = bean.getClass();
    Collections.addAll(types, bean.getClass().getInterfaces());

    while (type != null) {
      types.add(type);
      type = type.getSuperclass();
    }

    return types;
  }
}
