/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.lib.spring;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.tiogasolutions.dev.common.EnvUtils;
import org.tiogasolutions.dev.common.ReflectUtils;
import org.tiogasolutions.dev.common.StringUtils;

public class TiogaPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    private static final Logger log = LoggerFactory.getLogger(TiogaPropertyPlaceholderConfigurer.class);

    public TiogaPropertyPlaceholderConfigurer(String propertyName, String locationString) throws FileNotFoundException, MalformedURLException {
        if (StringUtils.isBlank((Object)propertyName)) {
            String msg = "Unable to locate the secret properties file - the system or environment property name was not specified.";
            throw new IllegalArgumentException(msg);
        }
        ArrayList<Object> resources = new ArrayList<Object>();
        ArrayList<String> locations = new ArrayList<String>();
        Collections.addAll(locations, locationString.split(","));
        String secretLocation = EnvUtils.findProperty((String)propertyName, (String)"");
        if (StringUtils.isBlank((Object)secretLocation)) {
            log.warn("Unable to locate the secret properties file - the system or environment property \"{}\" was found but is null.", (Object)propertyName);
        }
        locations.add(secretLocation);
        for (String location : locations) {
            if (location == null || StringUtils.isBlank((Object)(location = location.trim()))) continue;
            if (location.startsWith("file:")) {
                File file = new File(URI.create(location));
                resources.add(new FileSystemResource(file));
                continue;
            }
            if (location.startsWith("classpath:")) {
                location = location.substring(10);
                resources.add(new ClassPathResource(location));
                continue;
            }
            if (location.startsWith("http:") || location.startsWith("https:")) {
                resources.add(new UrlResource(location));
                continue;
            }
            String msg = String.format("Cannot create resource from \"%s\".", location);
            throw new IllegalArgumentException(msg);
        }
        this.setLocations((Resource[])ReflectUtils.toArray(Resource.class, resources));
    }
}

