/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.client;

import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.concurrent.Future;
import javax.swing.JOptionPane;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.dev.common.IoUtils;
import org.tiogasolutions.dev.common.ReflectUtils;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.dev.common.id.uuid.TimeUuid;
import org.tiogasolutions.dev.common.net.HttpStatusCode;
import org.tiogasolutions.dev.domain.query.QueryResult;
import org.tiogasolutions.notify.client.TestMainSupport;
import org.tiogasolutions.notify.notifier.LqNotifier;
import org.tiogasolutions.notify.notifier.builder.LqBuilder;
import org.tiogasolutions.notify.notifier.sender.LqSender;
import org.tiogasolutions.notify.notifier.sender.LqSimpleSender;
import org.tiogasolutions.notify.pub.DomainProfile;
import org.tiogasolutions.notify.pub.Notification;
import org.tiogasolutions.notify.pub.Request;
import org.tiogasolutions.notify.pub.Task;
import org.tiogasolutions.notify.sender.couch.LqCouchSender;
import org.tiogasolutions.notify.sender.couch.LqCouchSenderSetup;
import org.tiogasolutions.notify.sender.http.LqHttpSender;
import org.tiogasolutions.notify.sender.http.LqHttpSenderConfig;

public class AdminApp
extends TestMainSupport {
    private static final Logger log = LoggerFactory.getLogger(AdminApp.class);

    public static void main(String[] args) {
        try {
            new AdminApp().run();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public AdminApp() {
        ClientConfig httpClientConfig = new ClientConfig();
        ClientBuilder clientBuilder = ClientBuilder.newBuilder().withConfig((Configuration)httpClientConfig);
        this.client = clientBuilder.build();
        this.client.register((Object)HttpAuthenticationFeature.basic((String)"jacobp", (String)"Testing123"));
    }

    private void run() throws Exception {
        this.domainName = System.getProperties().getProperty("user.name");
        if ("jacob".equals(this.domainName)) {
            this.domainName = "jacobp";
        }
        this.domainName = JOptionPane.showInputDialog("New/Existing domain name:", (Object)this.domainName);
        if (this.domainName == null) {
            return;
        }
        DomainProfile domainProfile = this.getOrCreateDomainProfile(this.client, this.domainName);
        this.apiKey = domainProfile.getApiKey();
        this.apiPassword = domainProfile.getApiPassword();
        LinkedHashMap<String, Operation> operationsMap = new LinkedHashMap<String, Operation>();
        operationsMap.put("Status", this::checkStatus);
        operationsMap.put("Generate Requests (Couch Sender)", this::generateRequestsByCouch);
        operationsMap.put("Generate Requests (HTTP Sender)", this::generateRequestsByHttp);
        operationsMap.put("Update Catalog", this::updateCatalog);
        operationsMap.put("Kill 'em All", this::deleteAll);
        operationsMap.put("Delete Tasks", this::deleteTasks);
        operationsMap.put("Delete Requests", this::deleteRequests);
        operationsMap.put("Delete Notifications", this::deleteNotifications);
        String name = null;
        while ((name = (String)JOptionPane.showInputDialog(null, "Please select an admin operation", "Select Operation", 3, null, ReflectUtils.toArray(String.class, operationsMap.keySet()), name)) != null) {
            ((Operation)operationsMap.get(name)).execute();
        }
    }

    public void deleteAll() throws Exception {
        this.deleteRequests();
        this.deleteNotifications();
        this.deleteTasks();
    }

    public void deleteTasks() throws Exception {
        int count = 0;
        try {
            QueryResult<Task> result;
            do {
                result = this.getTasks(null);
                count += result.getSize();
                result.getResults().forEach(task -> this.deleteTask(this.domainName, (Task)task));
            } while (result.isNotEmpty());
        }
        catch (RuntimeJsonMappingException result) {
            // empty catch block
        }
        String msg = String.format("%s task(s) were deleted.", count);
        JOptionPane.showMessageDialog(null, msg, "Tasks Deleted", 1);
    }

    public void deleteNotifications() throws Exception {
        int count = 0;
        try {
            QueryResult<Notification> result;
            do {
                result = this.getNotifications(this.domainName);
                count += result.getSize();
                result.getResults().forEach(request -> this.deleteNotification(this.domainName, (Notification)request));
            } while (result.isNotEmpty());
        }
        catch (RuntimeJsonMappingException result) {
            // empty catch block
        }
        String msg = String.format("%s notification(s) were deleted.", count);
        JOptionPane.showMessageDialog(null, msg, "Notifications Deleted", 1);
    }

    public void deleteRequests() throws Exception {
        int count = 0;
        try {
            QueryResult<Request> result;
            do {
                result = this.getRequests(this.domainName, null);
                count += result.getSize();
                result.getResults().forEach(request -> this.deleteRequest(this.domainName, (Request)request));
            } while (result.isNotEmpty());
        }
        catch (RuntimeJsonMappingException result) {
            // empty catch block
        }
        String msg = String.format("%s request(s) were deleted.", count);
        JOptionPane.showMessageDialog(null, msg, "Requests Deleted", 1);
    }

    private void updateCatalog() throws Exception {
        File currentDir = new File("").getAbsoluteFile();
        File configDir = new File(currentDir, "/runtime/config/");
        String fileName = String.format("route-catalog-%s.json", this.domainName);
        File jsonFile = new File(configDir, fileName);
        String json = IoUtils.toString((File)jsonFile);
        Response response = this.client.target("http://localhost:8080/lq-server/api/v1/admin/domains").path(this.domainName).path("route-catalog").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)json, (MediaType)MediaType.APPLICATION_JSON_TYPE));
        HttpStatusCode statusCode = HttpStatusCode.findByCode((int)response.getStatus());
        if (statusCode != HttpStatusCode.OK) {
            throw new ApiException(statusCode, "Update of route catalog FAILED: " + response.getStatusInfo(), new String[0]);
        }
        JOptionPane.showMessageDialog(null, "The catalog has been updated:\n" + jsonFile, "Catalog Updated", 1);
    }

    public void generateRequestsByHttp() throws Exception {
        LqHttpSenderConfig config = new LqHttpSenderConfig().setUrl("http://localhost:8080/lq-server/api/v1/client/requests").setUserName(this.apiKey).setPassword(this.apiPassword);
        LqSimpleSender simpleSender = new LqSimpleSender();
        LqHttpSender httpSender = new LqHttpSender(config);
        httpSender.onResponse(r -> simpleSender.send(r.getRequest()));
        this.generateRequests(new LqNotifier((LqSender)httpSender));
        httpSender.dispose();
    }

    public void checkStatus() throws Exception {
        Response response = this.client.target("http://localhost:8080/lq-server/api/v1/status").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        HttpStatusCode statusCode = HttpStatusCode.findByCode((int)response.getStatus());
        if (statusCode != HttpStatusCode.OK) {
            throw new ApiException(statusCode, "Get of tasks FAILED: " + response.getStatusInfo(), new String[0]);
        }
        String json = (String)response.readEntity(String.class);
        JOptionPane.showMessageDialog(null, json, "Status: " + statusCode, 1);
    }

    public void generateRequestsByCouch() throws Exception {
        LqCouchSenderSetup setup = this.getCouchSenderSetup();
        LqCouchSender sender = new LqCouchSender(setup);
        sender.onFailure(f -> AdminApp.throwError("Failure in SENDING request: " + f.getThrowable().getMessage()));
        sender.onFailure(f -> AdminApp.throwError("Failure in SENDING attachment: " + f.getThrowable().getMessage()));
        this.generateRequests(new LqNotifier((LqSender)sender));
        sender.dispose();
    }

    private void generateRequests(LqNotifier notifier) {
        String countString = JOptionPane.showInputDialog("How many task should we create?", (Object)"1");
        if (countString == null) {
            return;
        }
        int notificationsToSend = Integer.valueOf(countString.trim());
        notifier.onBegin(b -> b.topic("hn-test").trackingId(TimeUuid.randomUUID().toString()));
        ArrayList<Future> futures = new ArrayList<Future>();
        for (int i = 0; i < notificationsToSend; ++i) {
            LqBuilder builder = notifier.begin().topic("PubFi").summary("Here is a longer summary message. There really is no maximum length but it would be awkward for it to be too long: " + i).trait("key1", (Object)"value1").trait("index", (Object)String.valueOf(i)).trait("no_value_key", null).exception(new Throwable("This is notification exception")).attach("attachOne", "text/plain", "Test main attachment one").attach("attachTwo", "text/plain", "Test main attachment two");
            Future future = builder.send();
            futures.add(future);
            log.debug("Notification " + i);
        }
        while (!futures.isEmpty()) {
            for (Future future : futures.toArray(new Future[futures.size()])) {
                if (!future.isDone()) continue;
                futures.remove(future);
            }
        }
        this.startReceiver();
    }

    private LqCouchSenderSetup getCouchSenderSetup() throws IOException {
        if ("jacobp".equals(this.domainName)) {
            return new LqCouchSenderSetup("http://localhost:5984", "notify-" + this.domainName + "-request", "app-user", "app-user");
        }
        DomainProfile domainProfile = this.getOrCreateDomainProfile(this.client, this.domainName);
        return new LqCouchSenderSetup("http://localhost:5984", domainProfile.getRequestDbName(), domainProfile.getApiKey(), domainProfile.getApiPassword());
    }

    private static void throwError(String msg) {
        System.out.println(msg);
        System.out.flush();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static interface Operation {
        public void execute() throws Exception;
    }
}

