/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import java.io.IOException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.dev.common.net.HttpStatusCode;
import org.tiogasolutions.dev.domain.query.QueryResult;
import org.tiogasolutions.dev.jackson.TiogaJacksonObjectMapper;
import org.tiogasolutions.notify.pub.DomainProfile;
import org.tiogasolutions.notify.pub.Notification;
import org.tiogasolutions.notify.pub.Request;
import org.tiogasolutions.notify.pub.RequestStatus;
import org.tiogasolutions.notify.pub.Task;
import org.tiogasolutions.notify.pub.TaskStatus;

public class TestMainSupport {
    protected Client client;
    protected String domainName;
    protected String apiKey;
    protected String apiPassword;

    public DomainProfile getOrCreateDomainProfile(Client client, String domainName) throws IOException {
        Response response = client.target("http://localhost:8080/lq-server/api/v1/admin/domains").path(domainName).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.entity((Object)"", (MediaType)MediaType.WILDCARD_TYPE));
        HttpStatusCode statusCode = HttpStatusCode.findByCode((int)response.getStatus());
        if (statusCode != HttpStatusCode.OK) {
            throw new ApiException(statusCode, "Put of domain FAILED: " + response.getStatusInfo(), new String[0]);
        }
        String json = (String)response.readEntity(String.class);
        TiogaJacksonObjectMapper objectMapper = new TiogaJacksonObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return (DomainProfile)objectMapper.readValue(json, DomainProfile.class);
    }

    public QueryResult<Task> getTasks(TaskStatus taskStatus) throws IOException {
        Response response = this.client.target("http://localhost:8080/lq-server/api/v1/admin/domains").path(this.domainName).path("tasks").queryParam("taskStatus", new Object[]{taskStatus}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        HttpStatusCode statusCode = HttpStatusCode.findByCode((int)response.getStatus());
        if (statusCode != HttpStatusCode.OK) {
            throw new ApiException(statusCode, "Get of tasks FAILED: " + response.getStatusInfo(), new String[0]);
        }
        String json = (String)response.readEntity(String.class);
        TiogaJacksonObjectMapper objectMapper = new TiogaJacksonObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return (QueryResult)objectMapper.readValue(json, QueryResult.class);
    }

    public QueryResult<Notification> getNotifications(String domainName) throws IOException {
        Response response = this.client.target("http://localhost:8080/lq-server/api/v1/admin/domains").path(domainName).path("notifications").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        HttpStatusCode statusCode = HttpStatusCode.findByCode((int)response.getStatus());
        if (statusCode != HttpStatusCode.OK) {
            throw new ApiException(statusCode, "Get of tasks FAILED: " + response.getStatusInfo(), new String[0]);
        }
        String json = (String)response.readEntity(String.class);
        TiogaJacksonObjectMapper objectMapper = new TiogaJacksonObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return (QueryResult)objectMapper.readValue(json, QueryResult.class);
    }

    public void deleteNotification(String domainName, Notification notification) {
        Response response = this.client.target("http://localhost:8080/lq-server/api/v1/admin/domains").path(domainName).path("notifications").path(notification.getNotificationId()).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete();
        HttpStatusCode statusCode = HttpStatusCode.findByCode((int)response.getStatus());
        if (statusCode != HttpStatusCode.NO_CONTENT) {
            throw new ApiException(statusCode, "Delete of notification FAILED: " + response.getStatusInfo(), new String[0]);
        }
    }

    public QueryResult<Request> getRequests(String domainName, RequestStatus requestStatus) throws IOException {
        Response response = this.client.target("http://localhost:8080/lq-server/api/v1/admin/domains").path(domainName).path("requests").queryParam("requestStatus", new Object[]{requestStatus}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        HttpStatusCode statusCode = HttpStatusCode.findByCode((int)response.getStatus());
        if (statusCode != HttpStatusCode.OK) {
            throw new ApiException(statusCode, "Get of tasks FAILED: " + response.getStatusInfo(), new String[0]);
        }
        String json = (String)response.readEntity(String.class);
        TiogaJacksonObjectMapper objectMapper = new TiogaJacksonObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return (QueryResult)objectMapper.readValue(json, QueryResult.class);
    }

    public void deleteTask(String domainName, Task task) {
        Response response = this.client.target("http://localhost:8080/lq-server/api/v1/admin/domains").path(domainName).path("tasks").path(task.getTaskId()).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete();
        HttpStatusCode statusCode = HttpStatusCode.findByCode((int)response.getStatus());
        if (statusCode != HttpStatusCode.NO_CONTENT) {
            throw new ApiException(statusCode, "Delete of tasks FAILED: " + response.getStatusInfo(), new String[0]);
        }
    }

    public void deleteRequest(String domainName, Request request) {
        Response response = this.client.target("http://localhost:8080/lq-server/api/v1/admin/domains").path(domainName).path("requests").path(request.getRequestId()).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete();
        HttpStatusCode statusCode = HttpStatusCode.findByCode((int)response.getStatus());
        if (statusCode != HttpStatusCode.NO_CONTENT) {
            throw new ApiException(statusCode, "Delete of request FAILED: " + response.getStatusInfo(), new String[0]);
        }
    }

    public void startReceiver() {
        Response response = this.client.target("http://localhost:8080/lq-server/api/v1/admin/system/request-receiver/actions/execute").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)"", (MediaType)MediaType.WILDCARD_TYPE));
        HttpStatusCode statusCode = HttpStatusCode.findByCode((int)response.getStatus());
        if (statusCode != HttpStatusCode.NO_CONTENT) {
            throw new ApiException(statusCode, "Start of request receiver failed: " + response.getStatusInfo(), new String[0]);
        }
    }

    public void startProcessor() {
        Response response = this.client.target("http://localhost:8080/lq-server/api/v1/admin/system/task-processor/actions/execute").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)"", (MediaType)MediaType.WILDCARD_TYPE));
        HttpStatusCode statusCode = HttpStatusCode.findByCode((int)response.getStatus());
        if (statusCode != HttpStatusCode.NO_CONTENT) {
            throw new ApiException(statusCode, "Start of task processor failed: " + response.getStatusInfo(), new String[0]);
        }
    }
}

