/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import java.io.IOException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.dev.common.net.HttpStatusCode;
import org.tiogasolutions.dev.domain.query.QueryResult;
import org.tiogasolutions.notify.NotifyObjectMapper;
import org.tiogasolutions.notify.pub.domain.DomainProfile;
import org.tiogasolutions.notify.pub.notification.Notification;
import org.tiogasolutions.notify.pub.request.NotificationRequest;
import org.tiogasolutions.notify.pub.request.NotificationRequestStatus;
import org.tiogasolutions.notify.pub.task.Task;
import org.tiogasolutions.notify.pub.task.TaskStatus;
import org.tiogasolutions.notify.sender.couch.CouchNotificationSenderSetup;

public class TestMainSupport {
    protected Client client;
    protected String domainName;
    protected String apiKey;
    protected String apiPassword;
    protected String apiPath;
    protected CouchNotificationSenderSetup couchSenderSetup;

    public DomainProfile getOrCreateDomainProfile(Client client, String domainName) throws IOException {
        Response response = client.target(this.apiPath + "/v2/admin/domains").path(domainName).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.entity((Object)"", (MediaType)MediaType.WILDCARD_TYPE));
        HttpStatusCode statusCode = HttpStatusCode.findByCode((int)response.getStatus());
        if (statusCode != HttpStatusCode.OK) {
            String msg = String.format("Put of domain \"%s\" FAILED: %s", domainName, response.getStatusInfo());
            throw ApiException.fromCode((HttpStatusCode)statusCode, (String)msg, (String[])new String[0]);
        }
        String json = (String)response.readEntity(String.class);
        NotifyObjectMapper objectMapper = new NotifyObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return (DomainProfile)objectMapper.readValue(json, DomainProfile.class);
    }

    public QueryResult<Task> getTasks(TaskStatus taskStatus) throws IOException {
        Response response = this.client.target(this.apiPath + "/v2/admin/domains").path(this.domainName).path("tasks").queryParam("taskStatus", new Object[]{taskStatus}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        HttpStatusCode statusCode = HttpStatusCode.findByCode((int)response.getStatus());
        if (statusCode != HttpStatusCode.OK) {
            throw ApiException.fromCode((HttpStatusCode)statusCode, (String)("Get of tasks FAILED: " + response.getStatusInfo()), (String[])new String[0]);
        }
        String json = (String)response.readEntity(String.class);
        NotifyObjectMapper objectMapper = new NotifyObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return (QueryResult)objectMapper.readValue(json, QueryResult.class);
    }

    public QueryResult<Notification> getNotifications(String domainName) throws IOException {
        Response response = this.client.target(this.apiPath + "/v2/admin/domains").path(domainName).path("notifications").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        HttpStatusCode statusCode = HttpStatusCode.findByCode((int)response.getStatus());
        if (statusCode != HttpStatusCode.OK) {
            throw ApiException.fromCode((HttpStatusCode)statusCode, (String)("Get of tasks FAILED: " + response.getStatusInfo()), (String[])new String[0]);
        }
        String json = (String)response.readEntity(String.class);
        NotifyObjectMapper objectMapper = new NotifyObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return (QueryResult)objectMapper.readValue(json, QueryResult.class);
    }

    public void deleteNotification(String domainName, Notification notification) {
        Response response = this.client.target(this.apiPath + "/v2/admin/domains").path(domainName).path("notifications").path(notification.getNotificationId()).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete();
        HttpStatusCode statusCode = HttpStatusCode.findByCode((int)response.getStatus());
        if (statusCode != HttpStatusCode.NO_CONTENT) {
            throw ApiException.fromCode((HttpStatusCode)statusCode, (String)("Delete of notification FAILED: " + response.getStatusInfo()), (String[])new String[0]);
        }
    }

    public QueryResult<NotificationRequest> getRequests(String domainName, NotificationRequestStatus requestStatus) throws IOException {
        Response response = this.client.target(this.apiPath + "/v2/admin/domains").path(domainName).path("requests").queryParam("requestStatus", new Object[]{requestStatus}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        HttpStatusCode statusCode = HttpStatusCode.findByCode((int)response.getStatus());
        if (statusCode != HttpStatusCode.OK) {
            throw ApiException.fromCode((HttpStatusCode)statusCode, (String)("Get of tasks FAILED: " + response.getStatusInfo()), (String[])new String[0]);
        }
        String json = (String)response.readEntity(String.class);
        NotifyObjectMapper objectMapper = new NotifyObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return (QueryResult)objectMapper.readValue(json, QueryResult.class);
    }

    public void deleteTask(String domainName, Task task) {
        Response response = this.client.target(this.apiPath + "/v2/admin/domains").path(domainName).path("tasks").path(task.getTaskId()).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete();
        HttpStatusCode statusCode = HttpStatusCode.findByCode((int)response.getStatus());
        if (statusCode != HttpStatusCode.NO_CONTENT) {
            throw ApiException.fromCode((HttpStatusCode)statusCode, (String)("Delete of tasks FAILED: " + response.getStatusInfo()), (String[])new String[0]);
        }
    }

    public void deleteRequest(String domainName, NotificationRequest request) {
        Response response = this.client.target(this.apiPath + "/v2/admin/domains").path(domainName).path("requests").path(request.getRequestId()).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete();
        HttpStatusCode statusCode = HttpStatusCode.findByCode((int)response.getStatus());
        if (statusCode != HttpStatusCode.NO_CONTENT) {
            throw ApiException.fromCode((HttpStatusCode)statusCode, (String)("Delete of request FAILED: " + response.getStatusInfo()), (String[])new String[0]);
        }
    }

    public void startReceiver() {
        Response response = this.client.target(this.apiPath + "/v2/admin/system/request-receiver/actions/execute").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)"", (MediaType)MediaType.WILDCARD_TYPE));
        HttpStatusCode statusCode = HttpStatusCode.findByCode((int)response.getStatus());
        if (statusCode != HttpStatusCode.NO_CONTENT) {
            throw ApiException.fromCode((HttpStatusCode)statusCode, (String)("Start of request receiver failed: " + response.getStatusInfo()), (String[])new String[0]);
        }
    }

    public void startProcessor() {
        Response response = this.client.target(this.apiPath + "/v2/admin/system/task-processor/actions/execute").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)"", (MediaType)MediaType.WILDCARD_TYPE));
        HttpStatusCode statusCode = HttpStatusCode.findByCode((int)response.getStatus());
        if (statusCode != HttpStatusCode.NO_CONTENT) {
            throw ApiException.fromCode((HttpStatusCode)statusCode, (String)("Start of task processor failed: " + response.getStatusInfo()), (String[])new String[0]);
        }
    }
}

