/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine.core.v1;

import java.util.Collection;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.tiogasolutions.dev.common.exceptions.ApiNotFoundException;
import org.tiogasolutions.dev.domain.query.ListQueryResult;
import org.tiogasolutions.dev.domain.query.QueryResult;
import org.tiogasolutions.notify.engine.core.v1.NotificationsResourceV1;
import org.tiogasolutions.notify.engine.core.v1.RequestResourceV1;
import org.tiogasolutions.notify.engine.core.v1.RouteCatalogResourceV1;
import org.tiogasolutions.notify.engine.core.v1.SystemResourceV1;
import org.tiogasolutions.notify.engine.core.v1.TasksResourceV1;
import org.tiogasolutions.notify.kernel.EventBus;
import org.tiogasolutions.notify.kernel.domain.DomainKernel;
import org.tiogasolutions.notify.kernel.execution.ExecutionManager;
import org.tiogasolutions.notify.kernel.notification.NotificationKernel;
import org.tiogasolutions.notify.kernel.processor.ProcessorExecutor;
import org.tiogasolutions.notify.kernel.receiver.ReceiverExecutor;
import org.tiogasolutions.notify.pub.DomainProfile;

public class AdminResourceV1 {
    private final DomainKernel domainKernel;
    private final ExecutionManager executionManager;
    private final NotificationKernel notificationKernel;
    private final ReceiverExecutor receiverExecutor;
    private final ProcessorExecutor processorExecutor;
    private final EventBus eventBus;

    public AdminResourceV1(ExecutionManager executionManager, DomainKernel domainKernel, NotificationKernel notificationKernel, ReceiverExecutor receiverExecutor, ProcessorExecutor processorExecutor, EventBus eventBus) {
        this.eventBus = eventBus;
        this.domainKernel = domainKernel;
        this.executionManager = executionManager;
        this.notificationKernel = notificationKernel;
        this.receiverExecutor = receiverExecutor;
        this.processorExecutor = processorExecutor;
    }

    @GET
    public Response getDefaultPage() {
        return Response.ok((Object)"{\"status\":\"200\"}", (String)"application/json").build();
    }

    @GET
    @Path(value="/domains")
    @Produces(value={"application/json"})
    public QueryResult<DomainProfile> getDomainProfiles() {
        List domainProfiles = this.domainKernel.listActiveDomainProfiles();
        return ListQueryResult.newComplete(DomainProfile.class, (Collection)domainProfiles);
    }

    @GET
    @Path(value="/domains/{domainName}")
    @Produces(value={"application/json"})
    public Response getDomainProfile(@PathParam(value="domainName") String domainName) {
        try {
            DomainProfile domainProfile = this.domainKernel.findByDomainName(domainName);
            return Response.ok((Object)domainProfile).build();
        }
        catch (ApiNotFoundException e) {
            return Response.status((int)404).entity((Object)e).build();
        }
    }

    @PUT
    @Path(value="/domains/{domainName}")
    @Produces(value={"application/json"})
    public DomainProfile createDomain(@PathParam(value="domainName") String domainName) {
        return this.domainKernel.getOrCreateDomain(domainName);
    }

    @Path(value="/domains/{domainName}/notifications")
    public NotificationsResourceV1 getNotificationsResourceV1(@PathParam(value="domainName") String domainName) {
        DomainProfile domainProfile = this.domainKernel.findByDomainName(domainName);
        this.executionManager.newApiContext(domainProfile);
        return new NotificationsResourceV1(this.executionManager, this.notificationKernel);
    }

    @Path(value="/domains/{domainName}/route-catalog")
    public RouteCatalogResourceV1 getRouteCatalogResourceV1(@PathParam(value="domainName") String domainName) {
        DomainProfile domainProfile = this.domainKernel.findByDomainName(domainName);
        this.executionManager.newApiContext(domainProfile);
        return new RouteCatalogResourceV1(this.executionManager, this.domainKernel);
    }

    @Path(value="/domains/{domainName}/requests")
    public RequestResourceV1 getRequestResourceV1(@PathParam(value="domainName") String domainName) {
        DomainProfile domainProfile = this.domainKernel.findByDomainName(domainName);
        this.executionManager.newApiContext(domainProfile);
        return new RequestResourceV1(this.executionManager, this.domainKernel, this.eventBus);
    }

    @Path(value="/domains/{domainName}/tasks")
    public TasksResourceV1 getTasksResourceV1(@PathParam(value="domainName") String domainName) {
        DomainProfile domainProfile = this.domainKernel.findByDomainName(domainName);
        this.executionManager.newApiContext(domainProfile);
        return new TasksResourceV1(this.executionManager, this.domainKernel, this.notificationKernel);
    }

    @Path(value="/system")
    public SystemResourceV1 getSystemResourceV1() {
        return new SystemResourceV1(this.receiverExecutor, this.processorExecutor);
    }
}

