/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine.web;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.dev.common.exceptions.ApiException;

public class StaticContentReader {
    private static final Logger logger = LoggerFactory.getLogger(StaticContentReader.class);
    private final Path rootPath;

    public StaticContentReader(Path rootPath) {
        this.rootPath = rootPath;
        logger.info("Reading static resources from: " + rootPath);
    }

    public StaticContentReader(String path) {
        this.rootPath = Paths.get(path, new String[0]);
        logger.info("Reading static resources from: " + this.rootPath);
    }

    public StaticContentReader() {
        this.rootPath = null;
        logger.info("Reading static content from");
    }

    public byte[] readContent(UriInfo uriInfo) {
        String contentPath = uriInfo.getPath();
        contentPath = contentPath.startsWith("/") ? contentPath.substring(1) : contentPath;
        Path fullPath = this.rootPath.resolve(contentPath);
        try {
            return Files.readAllBytes(fullPath);
        }
        catch (IOException e) {
            throw ApiException.badRequest((String)("Error reading static content " + fullPath), (String[])new String[0]);
        }
    }

    public byte[] readContent(String contentPath) {
        contentPath = contentPath.startsWith("/") ? contentPath.substring(1) : contentPath;
        Path fullPath = this.rootPath.resolve(contentPath);
        try {
            return Files.readAllBytes(fullPath);
        }
        catch (IOException e) {
            throw ApiException.badRequest((String)("Error reading static content " + fullPath), (String[])new String[0]);
        }
    }
}

