/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine.core;

import java.net.URI;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.tiogasolutions.notify.engine.core.AppResource;
import org.tiogasolutions.notify.engine.core.v1.AdminResourceV1;
import org.tiogasolutions.notify.engine.core.v1.ClientResourceV1;
import org.tiogasolutions.notify.engine.web.StaticContentReader;
import org.tiogasolutions.notify.engine.web.SystemStatus;
import org.tiogasolutions.notify.kernel.EventBus;
import org.tiogasolutions.notify.kernel.domain.DomainKernel;
import org.tiogasolutions.notify.kernel.execution.ExecutionManager;
import org.tiogasolutions.notify.kernel.notification.NotificationKernel;
import org.tiogasolutions.notify.kernel.processor.ProcessorExecutor;
import org.tiogasolutions.notify.kernel.receiver.ReceiverExecutor;

@Path(value="/")
public class EngRootResource {
    @Context
    UriInfo uriInfo;
    @Inject
    private DomainKernel domainKernel;
    @Inject
    private ExecutionManager executionManager;
    @Inject
    private NotificationKernel notificationKernel;
    @Inject
    private ReceiverExecutor receiverExecutor;
    @Inject
    private ProcessorExecutor processorExecutor;
    @Inject
    private EventBus eventBus;
    @Inject
    private StaticContentReader staticContentReader;

    @GET
    @Produces(value={"text/html"})
    public Response getDefaultPage() throws Exception {
        URI uri = this.uriInfo.getBaseUriBuilder().path("/app").build(new Object[0]);
        return Response.seeOther((URI)uri).build();
    }

    @Path(value="/app")
    public AppResource getAppResource() {
        return new AppResource(this.staticContentReader, this.uriInfo);
    }

    @Path(value="/api/v1/client")
    public ClientResourceV1 getClientResource() {
        return new ClientResourceV1(this.executionManager, this.domainKernel, this.notificationKernel, this.eventBus);
    }

    @Path(value="/api/v1/admin")
    public AdminResourceV1 getAdminResource() {
        return new AdminResourceV1(this.executionManager, this.domainKernel, this.notificationKernel, this.receiverExecutor, this.processorExecutor, this.eventBus);
    }

    @GET
    @Path(value="/api/v1/status")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    public SystemStatus getStatus() {
        return new SystemStatus(this.receiverExecutor.getExecutorStatus(), this.processorExecutor.getExecutorStatus());
    }
}

