/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine.core.v1;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.dev.domain.query.ListQueryResult;
import org.tiogasolutions.dev.domain.query.QueryResult;
import org.tiogasolutions.notify.engine.core.v1.SimpleRequestEntryResourceV1;
import org.tiogasolutions.notify.kernel.EventBus;
import org.tiogasolutions.notify.kernel.LqPubUtils;
import org.tiogasolutions.notify.kernel.domain.DomainKernel;
import org.tiogasolutions.notify.kernel.execution.ExecutionContext;
import org.tiogasolutions.notify.kernel.execution.ExecutionManager;
import org.tiogasolutions.notify.kernel.request.LqRequestEntity;
import org.tiogasolutions.notify.kernel.request.LqRequestEntityStatus;
import org.tiogasolutions.notify.kernel.request.LqRequestStore;
import org.tiogasolutions.notify.notifier.request.LqRequest;
import org.tiogasolutions.notify.pub.DomainProfile;
import org.tiogasolutions.notify.pub.Request;

public class RequestResourceV1 {
    private final DomainKernel domainKernel;
    private final ExecutionManager executionManager;
    private final EventBus eventBus;

    public RequestResourceV1(ExecutionManager executionManager, DomainKernel domainKernel, EventBus eventBus) {
        this.eventBus = eventBus;
        this.domainKernel = domainKernel;
        this.executionManager = executionManager;
    }

    private DomainProfile getDomainProfile() {
        ExecutionContext ec = this.executionManager.context();
        return this.domainKernel.findByApiKey(ec.getApiKey());
    }

    @GET
    @Produces(value={"application/json"})
    public QueryResult<Request> getRequests(@QueryParam(value="status") LqRequestEntityStatus status) {
        DomainProfile domainProfile = this.getDomainProfile();
        CouchDatabase requestDb = this.domainKernel.requestDb(domainProfile);
        LqRequestStore requestStore = new LqRequestStore(requestDb);
        List requestEntities = requestStore.findByStatus(status);
        ArrayList requests = new ArrayList();
        requestEntities.forEach(entity -> {
            Request request = LqPubUtils.toRequest((LqRequestEntity)entity);
            requests.add(request);
        });
        return ListQueryResult.newComplete(Request.class, requests);
    }

    @PUT
    @Produces(value={"application/json"})
    public Response putRequest(@Context UriInfo uriInfo, LqRequest request) {
        LqRequestEntity requestEntity = LqRequestEntity.newEntity((LqRequest)request);
        CouchDatabase requestDb = this.domainKernel.requestDb(this.getDomainProfile());
        requestEntity = new LqRequestStore(requestDb).saveAndReload(requestEntity);
        requestEntity.ready();
        String domainName = this.executionManager.context().getDomainName();
        this.eventBus.requestCreated(domainName, requestEntity);
        URI uri = uriInfo.getRequestUriBuilder().path(requestEntity.getRequestId()).build(new Object[0]);
        return Response.created((URI)uri).build();
    }

    @Path(value="simple-entry")
    public SimpleRequestEntryResourceV1 getSimpleRequestEntryV1() {
        return new SimpleRequestEntryResourceV1(this.executionManager, this.domainKernel, this.eventBus);
    }

    @DELETE
    @Path(value="{requestId}")
    @Produces(value={"application/json"})
    public Response deleteRequest(@PathParam(value="requestId") String requestId) {
        DomainProfile domainProfile = this.getDomainProfile();
        CouchDatabase requestDb = this.domainKernel.requestDb(domainProfile);
        LqRequestStore requestStore = new LqRequestStore(requestDb);
        requestStore.deleteRequest(requestId);
        return Response.noContent().build();
    }
}

