/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine.v1;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.tiogasolutions.dev.common.exceptions.ApiNotFoundException;
import org.tiogasolutions.notify.engine.v1.NotificationRequestResourceV1;
import org.tiogasolutions.notify.engine.v1.NotificationsResourceV1;
import org.tiogasolutions.notify.engine.v1.RouteCatalogResourceV1;
import org.tiogasolutions.notify.engine.v1.SimpleRequestEntryResourceV1;
import org.tiogasolutions.notify.kernel.domain.DomainKernel;
import org.tiogasolutions.notify.kernel.event.EventBus;
import org.tiogasolutions.notify.kernel.execution.ExecutionManager;
import org.tiogasolutions.notify.kernel.notification.NotificationKernel;
import org.tiogasolutions.notify.pub.domain.DomainProfile;
import org.tiogasolutions.notify.pub.domain.DomainSummary;

public class ClientResourceV1 {
    private final EventBus eventBus;
    private final DomainKernel domainKernel;
    private final ExecutionManager executionManager;
    private final NotificationKernel notificationKernel;

    public ClientResourceV1(ExecutionManager executionManager, DomainKernel domainKernel, NotificationKernel notificationKernel, EventBus eventBus) {
        this.eventBus = eventBus;
        this.domainKernel = domainKernel;
        this.executionManager = executionManager;
        this.notificationKernel = notificationKernel;
    }

    @GET
    @Produces(value={"application/json"})
    public DomainProfile getDomainProfile() {
        String domainName = this.executionManager.context().getDomainName();
        return this.domainKernel.findByDomainName(domainName);
    }

    @GET
    @Path(value="sign-in")
    @Produces(value={"application/json"})
    public DomainProfile signIn() {
        return this.getDomainProfile();
    }

    @GET
    @Path(value="summary")
    @Produces(value={"application/json"})
    public Response getDomainSummary() {
        try {
            String domainName = this.executionManager.context().getDomainName();
            DomainSummary summary = this.domainKernel.fetchSummary(domainName);
            return Response.ok((Object)summary).build();
        }
        catch (ApiNotFoundException e) {
            return Response.status((int)404).entity((Object)e).build();
        }
    }

    @Path(value="/notifications")
    public NotificationsResourceV1 getNotificationsResource() {
        return new NotificationsResourceV1(this.executionManager, this.notificationKernel);
    }

    @Path(value="/route-catalog")
    public RouteCatalogResourceV1 getRouteCatalogResource() {
        return new RouteCatalogResourceV1(this.executionManager, this.domainKernel);
    }

    @Path(value="/requests")
    public NotificationRequestResourceV1 getRequestResourceV1() {
        return new NotificationRequestResourceV1(this.executionManager, this.domainKernel, this.eventBus);
    }

    @Path(value="/simple-request-entry")
    public SimpleRequestEntryResourceV1 getSimpleRequestEntryV1() {
        return new SimpleRequestEntryResourceV1(this.executionManager, this.domainKernel, this.eventBus);
    }
}

