/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine.v1;

import java.io.IOException;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.dev.common.exceptions.ApiNotFoundException;
import org.tiogasolutions.dev.domain.query.QueryResult;
import org.tiogasolutions.notify.kernel.execution.ExecutionManager;
import org.tiogasolutions.notify.kernel.notification.NotificationKernel;
import org.tiogasolutions.notify.pub.attachment.AttachmentHolder;
import org.tiogasolutions.notify.pub.attachment.AttachmentQuery;
import org.tiogasolutions.notify.pub.common.ExceptionInfo;
import org.tiogasolutions.notify.pub.notification.Notification;
import org.tiogasolutions.notify.pub.notification.NotificationQuery;

public class NotificationsResourceV1 {
    private final NotificationKernel notificationKernel;

    public NotificationsResourceV1(ExecutionManager executionManager, NotificationKernel notificationKernel) {
        this.notificationKernel = notificationKernel;
        if (!executionManager.hasContext()) {
            String msg = String.format("The execution context does not exist.", new Object[0]);
            throw new UnsupportedOperationException(msg);
        }
    }

    @GET
    @Produces(value={"application/json"})
    public QueryResult<Notification> getNotifications(@QueryParam(value="offset") int offset, @QueryParam(value="limit") int limit, @QueryParam(value="notificationId") String notificationId, @QueryParam(value="topic") String topic, @QueryParam(value="summary") String summary, @QueryParam(value="traitKey") String traitKey, @QueryParam(value="traitValue") String traitValue) {
        if (limit == 0) {
            limit = 10;
        }
        NotificationQuery query = new NotificationQuery().setLimit(limit).setOffset(offset).setNotificationId(notificationId).setTopic(topic).setTraitKey(traitKey).setSummary(summary).setTraitValue(traitValue);
        return this.notificationKernel.query(query);
    }

    @DELETE
    @Path(value="/{notificationId}")
    @Produces(value={"application/json"})
    public Response deleteNotification(@PathParam(value="notificationId") String notificationId) {
        this.notificationKernel.deleteNotification(notificationId);
        return Response.noContent().build();
    }

    @GET
    @Path(value="/{notificationId}")
    @Produces(value={"application/json"})
    public Response getNotification(@PathParam(value="notificationId") String notificationId) {
        try {
            Notification notification = this.notificationKernel.findNotificationById(notificationId);
            return Response.ok((Object)notification).build();
        }
        catch (ApiNotFoundException e) {
            return Response.status((int)404).entity((Object)e).build();
        }
    }

    @GET
    @Path(value="/{notificationId}/exception-info")
    @Produces(value={"application/json"})
    public Response getExceptionInfo(@PathParam(value="notificationId") String notificationId) {
        try {
            Notification notification = this.notificationKernel.findNotificationById(notificationId);
            ExceptionInfo exception = notification.getExceptionInfo();
            if (exception == null) {
                String msg = String.format("Exception info not found for notification %s.", notificationId);
                ApiNotFoundException e = ApiException.notFound((String)msg, (String[])new String[0]);
                return Response.status((int)404).entity((Object)e).build();
            }
            return Response.ok((Object)exception).build();
        }
        catch (ApiNotFoundException e) {
            return Response.status((int)404).entity((Object)e).build();
        }
    }

    @GET
    @Path(value="/{notificationId}/attachments/{attachmentName}")
    public Response getAttachment(@PathParam(value="notificationId") String notificationId, @PathParam(value="attachmentName") String attachmentName) throws IOException {
        AttachmentQuery query = new AttachmentQuery().setNotificationId(notificationId).setAttachmentName(attachmentName);
        AttachmentHolder attachmentHolder = this.notificationKernel.query(query);
        return Response.ok((Object)attachmentHolder.getContent(), (String)attachmentHolder.getContentType()).build();
    }
}

