/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine.web;

import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.tiogasolutions.lib.jaxrs.TiogaJaxRsExceptionMapper;

@Provider
@Component
public class EngineExceptionMapper
extends TiogaJaxRsExceptionMapper {
    private static final Logger log = LoggerFactory.getLogger(EngineExceptionMapper.class);

    public EngineExceptionMapper() {
        super(true);
        log.info("Created");
    }

    public Response toResponse(Throwable ex) {
        return super.toResponse(ex);
    }

    protected void logInfo(String msg, Throwable ex) {
        log.info(msg, ex);
    }

    protected void logError(String msg, Throwable ex) {
        log.error(msg, ex);
    }

    protected void logMessage(String msg) {
        System.out.printf("EVENT: %s%n", msg);
    }

    protected void logException(Throwable throwable, int status) {
        List<Integer> minor;
        String msg = "Status " + status;
        if (this.uriInfo != null) {
            msg = msg + " ";
            msg = msg + this.uriInfo.getRequestUri();
        }
        if ((minor = Arrays.asList(400, 401)).contains(status)) {
            this.logMessage(msg);
        } else {
            this.logError(msg, throwable);
        }
    }
}

