/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine.web.readers;

import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.dev.common.IoUtils;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.notify.engine.web.readers.StaticContentReader;

public class BundledStaticContentReader
implements StaticContentReader {
    private static final Logger logger = LoggerFactory.getLogger(StaticContentReader.class);
    private final String classPathRoot;

    public BundledStaticContentReader(String classPathRoot) {
        this.classPathRoot = classPathRoot;
    }

    @Override
    public byte[] readContent(UriInfo uriInfo) {
        String contentPath = uriInfo.getPath();
        return this.readContent(contentPath);
    }

    @Override
    public byte[] readContent(String contentPath) {
        String resource = contentPath.startsWith("/") ? this.classPathRoot + contentPath : this.classPathRoot + "/" + contentPath;
        try {
            InputStream in = this.getClass().getResourceAsStream(resource);
            if (in == null && this.getClass().getResource(this.classPathRoot) == null) {
                String msg = String.format("Content root not found (%s). Build project to update resources.", this.classPathRoot);
                throw ApiException.notFound((String)msg, (String[])new String[0]);
            }
            if (in == null) {
                String msg = String.format("The resource was not found: %s", contentPath);
                throw ApiException.notFound((String)msg, (String[])new String[0]);
            }
            return IoUtils.toBytes((InputStream)in);
        }
        catch (IOException e) {
            throw ApiException.internalServerError((String)("Error reading embedded static content: " + resource), (String[])new String[0]);
        }
    }
}

