/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine.v2;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.dev.common.net.HttpStatusCode;
import org.tiogasolutions.lib.hal.HalItem;
import org.tiogasolutions.notify.engine.v2.AdminDomainResourceV2;
import org.tiogasolutions.notify.kernel.PubUtils;
import org.tiogasolutions.notify.kernel.domain.DomainKernel;
import org.tiogasolutions.notify.kernel.event.EventBus;
import org.tiogasolutions.notify.kernel.execution.ExecutionManager;
import org.tiogasolutions.notify.kernel.notification.NotificationKernel;
import org.tiogasolutions.notify.kernel.receiver.ReceiverExecutor;
import org.tiogasolutions.notify.kernel.task.TaskProcessorExecutor;
import org.tiogasolutions.notify.pub.domain.DomainProfile;

public class AdminDomainsResourceV2 {
    private final PubUtils pubUtils;
    private final DomainKernel domainKernel;
    private final ExecutionManager executionManager;
    private final NotificationKernel notificationKernel;
    private final ReceiverExecutor receiverExecutor;
    private final TaskProcessorExecutor processorExecutor;
    private final EventBus eventBus;

    public AdminDomainsResourceV2(PubUtils pubUtils, ExecutionManager executionManager, DomainKernel domainKernel, NotificationKernel notificationKernel, ReceiverExecutor receiverExecutor, TaskProcessorExecutor processorExecutor, EventBus eventBus) {
        this.pubUtils = pubUtils;
        this.eventBus = eventBus;
        this.domainKernel = domainKernel;
        this.executionManager = executionManager;
        this.notificationKernel = notificationKernel;
        this.receiverExecutor = receiverExecutor;
        this.processorExecutor = processorExecutor;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getDomainProfiles() {
        List domainProfiles = this.domainKernel.listActiveDomainProfiles();
        HalItem item = this.pubUtils.fromDomainProfileResults(HttpStatusCode.OK, domainProfiles);
        return this.pubUtils.toResponse(item).build();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response createDomainWithForm(@FormParam(value="domainName") String domainName) {
        if (StringUtils.isBlank((Object)domainName)) {
            throw ApiException.badRequest((String)"The domain name must be specified.", (String[])new String[0]);
        }
        DomainProfile domainProfile = this.domainKernel.createDomain(domainName);
        HalItem item = this.pubUtils.fromDomainProfile(HttpStatusCode.CREATED, domainProfile);
        return this.pubUtils.toResponse(item).build();
    }

    @Path(value="/{domainName}")
    public AdminDomainResourceV2 getAdminDomainResourceV1(@PathParam(value="domainName") String domainName) {
        return new AdminDomainResourceV2(this.pubUtils, this.executionManager, this.domainKernel, this.notificationKernel, this.receiverExecutor, this.processorExecutor, this.eventBus, domainName);
    }
}

