/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine.v2;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.tiogasolutions.notify.engine.v2.AdminDomainsResourceV2;
import org.tiogasolutions.notify.engine.v2.SystemResourceV2;
import org.tiogasolutions.notify.kernel.PubUtils;
import org.tiogasolutions.notify.kernel.domain.DomainKernel;
import org.tiogasolutions.notify.kernel.event.EventBus;
import org.tiogasolutions.notify.kernel.execution.ExecutionManager;
import org.tiogasolutions.notify.kernel.notification.NotificationKernel;
import org.tiogasolutions.notify.kernel.receiver.ReceiverExecutor;
import org.tiogasolutions.notify.kernel.task.TaskProcessorExecutor;

public class AdminResourceV2 {
    private final PubUtils pubUtils;
    private final DomainKernel domainKernel;
    private final ExecutionManager executionManager;
    private final NotificationKernel notificationKernel;
    private final ReceiverExecutor receiverExecutor;
    private final TaskProcessorExecutor processorExecutor;
    private final EventBus eventBus;

    public AdminResourceV2(PubUtils pubUtils, ExecutionManager executionManager, DomainKernel domainKernel, NotificationKernel notificationKernel, ReceiverExecutor receiverExecutor, TaskProcessorExecutor processorExecutor, EventBus eventBus) {
        this.pubUtils = pubUtils;
        this.eventBus = eventBus;
        this.domainKernel = domainKernel;
        this.executionManager = executionManager;
        this.notificationKernel = notificationKernel;
        this.receiverExecutor = receiverExecutor;
        this.processorExecutor = processorExecutor;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getDefaultPage() {
        return this.pubUtils.toAdmin().build();
    }

    @Path(value="/domains")
    public AdminDomainsResourceV2 getDomainProfiles() {
        return new AdminDomainsResourceV2(this.pubUtils, this.executionManager, this.domainKernel, this.notificationKernel, this.receiverExecutor, this.processorExecutor, this.eventBus);
    }

    @Path(value="/system")
    public SystemResourceV2 getSystemResourceV1() {
        return new SystemResourceV2(this.receiverExecutor, this.processorExecutor);
    }
}

