/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine.v2;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.dev.domain.query.ListQueryResult;
import org.tiogasolutions.dev.domain.query.QueryResult;
import org.tiogasolutions.notify.engine.v2.SimpleRequestEntryResourceV2;
import org.tiogasolutions.notify.kernel.domain.DomainKernel;
import org.tiogasolutions.notify.kernel.event.EventBus;
import org.tiogasolutions.notify.kernel.execution.ExecutionContext;
import org.tiogasolutions.notify.kernel.execution.ExecutionManager;
import org.tiogasolutions.notify.kernel.request.NotificationRequestEntity;
import org.tiogasolutions.notify.kernel.request.NotificationRequestStore;
import org.tiogasolutions.notify.pub.domain.DomainProfile;
import org.tiogasolutions.notify.pub.request.NotificationRequest;
import org.tiogasolutions.notify.pub.request.NotificationRequestStatus;

public class NotificationRequestResourceV2 {
    private final DomainKernel domainKernel;
    private final ExecutionManager executionManager;
    private final EventBus eventBus;

    public NotificationRequestResourceV2(ExecutionManager executionManager, DomainKernel domainKernel, EventBus eventBus) {
        this.eventBus = eventBus;
        this.domainKernel = domainKernel;
        this.executionManager = executionManager;
    }

    private DomainProfile getDomainProfile() {
        ExecutionContext ec = this.executionManager.context();
        return this.domainKernel.findByApiKey(ec.getApiKey());
    }

    @GET
    @Produces(value={"application/json"})
    public QueryResult<NotificationRequest> getRequests(@QueryParam(value="status") NotificationRequestStatus status) {
        DomainProfile domainProfile = this.getDomainProfile();
        CouchDatabase requestDb = this.domainKernel.requestDb(domainProfile);
        NotificationRequestStore requestStore = new NotificationRequestStore(requestDb);
        List requestEntities = requestStore.findByStatus(status);
        ArrayList requests = new ArrayList();
        requestEntities.forEach(entity -> requests.add(entity.toRequest()));
        return ListQueryResult.newComplete(NotificationRequest.class, requests);
    }

    @PUT
    @Produces(value={"application/json"})
    public Response putRequest(@Context UriInfo uriInfo, NotificationRequest request) {
        NotificationRequestEntity notificationRequestEntity = NotificationRequestEntity.newEntity((NotificationRequest)request);
        CouchDatabase requestDb = this.domainKernel.requestDb(this.getDomainProfile());
        notificationRequestEntity = new NotificationRequestStore(requestDb).saveAndReload(notificationRequestEntity);
        notificationRequestEntity.ready();
        String domainName = this.executionManager.context().getDomainName();
        this.eventBus.requestCreated(domainName, notificationRequestEntity);
        URI uri = uriInfo.getRequestUriBuilder().path(notificationRequestEntity.getRequestId()).build(new Object[0]);
        return Response.created((URI)uri).entity((Object)notificationRequestEntity).build();
    }

    @Path(value="simple-entry")
    public SimpleRequestEntryResourceV2 getSimpleRequestEntryV1() {
        return new SimpleRequestEntryResourceV2(this.executionManager, this.domainKernel, this.eventBus);
    }

    @DELETE
    @Path(value="{requestId}")
    @Produces(value={"application/json"})
    public Response deleteRequest(@PathParam(value="requestId") String requestId) {
        DomainProfile domainProfile = this.getDomainProfile();
        CouchDatabase requestDb = this.domainKernel.requestDb(domainProfile);
        NotificationRequestStore requestStore = new NotificationRequestStore(requestDb);
        requestStore.deleteRequest(requestId);
        return Response.noContent().build();
    }
}

