/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine.jobs;

import java.time.ZonedDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.notify.kernel.domain.DomainKernel;
import org.tiogasolutions.notify.kernel.request.NotificationRequestEntity;
import org.tiogasolutions.notify.kernel.request.NotificationRequestStore;
import org.tiogasolutions.notify.pub.domain.DomainProfile;
import org.tiogasolutions.notify.pub.request.NotificationRequestStatus;

public class PruneRequestsJob
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean running = false;
    private long requestsProcessed = 0L;
    private final String domainName;
    private final NotificationRequestStore requestStore;

    public PruneRequestsJob(DomainKernel domainKernel, String domainName) {
        this.domainName = domainName;
        DomainProfile domainProfile = domainKernel.findByDomainName(domainName);
        CouchDatabase requestDb = domainKernel.requestDb(domainProfile);
        this.requestStore = new NotificationRequestStore(requestDb);
    }

    @Override
    public void run() {
        this.running = true;
        try {
            this.deleteCompletedRequests(this.requestStore);
            this.deleteFailedRequests(this.requestStore);
            this.deleteProcessingRequests(this.requestStore);
        }
        catch (Exception e) {
            String msg = String.format("Exception deleting request for the domain %s.", this.domainName);
            this.log.error(msg, (Throwable)e);
        }
        finally {
            this.running = false;
            this.log.info("Finished pruning requests for the domain {}.", (Object)this.domainName);
        }
    }

    private void deleteCompletedRequests(NotificationRequestStore requestStore) {
        List requests = null;
        while (requests == null || requests.size() > 0) {
            requests = requestStore.findByStatus(NotificationRequestStatus.COMPLETED);
            this.log.info("Deleting {} \"completed\" requests for the domain {}.", (Object)requests.size(), (Object)this.domainName);
            for (NotificationRequestEntity request : requests) {
                ++this.requestsProcessed;
                requestStore.deleteRequest(request.getRequestId());
            }
        }
    }

    private void deleteFailedRequests(NotificationRequestStore requestStore) {
        List requests = null;
        while (requests == null || requests.size() > 0) {
            requests = requestStore.findByStatus(NotificationRequestStatus.FAILED);
            this.log.info("Deleting {} \"failed\" requests for the domain {}.", (Object)requests.size(), (Object)this.domainName);
            for (NotificationRequestEntity request : requests) {
                ++this.requestsProcessed;
                requestStore.deleteRequest(request.getRequestId());
            }
        }
    }

    private void deleteProcessingRequests(NotificationRequestStore requestStore) {
        List requests = null;
        while (requests == null || requests.size() > 0) {
            requests = requestStore.findByStatus(NotificationRequestStatus.PROCESSING, 100);
            this.log.info("Deleting {} 1-week-old \"processing\" requests for the domain {}.", (Object)requests.size(), (Object)this.domainName);
            for (NotificationRequestEntity request : requests) {
                if (!request.getCreatedAt().isBefore(ZonedDateTime.now().minusDays(7L))) continue;
                ++this.requestsProcessed;
                requestStore.deleteRequest(request.getRequestId());
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public Results getStartedResults() {
        return new Results(this.requestsProcessed, String.format("STARTED: Deleted %s requests from the domain %s.", this.requestsProcessed, this.domainName));
    }

    public Results getResults() {
        if (this.running) {
            return new Results(this.requestsProcessed, String.format("RUNNING: Deleted %s requests from the domain %s.", this.requestsProcessed, this.domainName));
        }
        return new Results(this.requestsProcessed, String.format("COMPLETED: Deleted %s requests from the domain %s.", this.requestsProcessed, this.domainName));
    }

    public static class Results {
        private final String message;
        private final long requestsProcessed;

        public Results(long requestsProcessed, String message) {
            this.requestsProcessed = requestsProcessed;
            this.message = message;
        }

        public long getRequestsProcessed() {
            return this.requestsProcessed;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

