/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine.v2;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.dev.common.net.HttpStatusCode;
import org.tiogasolutions.lib.hal.HalItem;
import org.tiogasolutions.notify.engine.v2.AdminDomainResourceV2;
import org.tiogasolutions.notify.kernel.PubUtils;
import org.tiogasolutions.notify.kernel.execution.ExecutionManager;
import org.tiogasolutions.notify.pub.domain.DomainProfile;

public class AdminDomainsResourceV2 {
    private static final Logger log = LoggerFactory.getLogger(AdminDomainsResourceV2.class);
    private final PubUtils pubUtils;
    private final ExecutionManager em;

    public AdminDomainsResourceV2(PubUtils pubUtils, ExecutionManager em) {
        log.info("Created");
        this.pubUtils = pubUtils;
        this.em = em;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getDomainProfiles() {
        List domainProfiles = this.em.getDomainKernel().listActiveDomainProfiles();
        HalItem item = this.pubUtils.fromDomainProfileResults(HttpStatusCode.OK, domainProfiles);
        return this.pubUtils.toResponse(item).build();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response createDomainWithForm(@FormParam(value="domainName") String domainName) {
        if (StringUtils.isBlank((Object)domainName)) {
            throw ApiException.badRequest((String)"The domain name must be specified.", (String[])new String[0]);
        }
        DomainProfile domainProfile = this.em.getDomainKernel().createDomain(domainName);
        HalItem item = this.pubUtils.fromDomainProfile(HttpStatusCode.CREATED, domainProfile);
        return this.pubUtils.toResponse(item).build();
    }

    @Path(value="/{domainName}")
    public AdminDomainResourceV2 getAdminDomainResourceV1(@PathParam(value="domainName") String domainName) {
        return new AdminDomainResourceV2(this.pubUtils, this.em, domainName);
    }
}

