/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.notifier.send;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.notify.notifier.send.AbstractNotificationSender;
import org.tiogasolutions.notify.notifier.send.SendNotificationRequest;
import org.tiogasolutions.notify.notifier.send.SendNotificationRequestJsonBuilder;
import org.tiogasolutions.notify.notifier.send.SendNotificationResponse;

public class LoggingNotificationSender
extends AbstractNotificationSender {
    private static final Logger log = LoggerFactory.getLogger(LoggingNotificationSender.class);
    private SendNotificationRequest lastRequest;

    @Override
    public Future<SendNotificationResponse> send(SendNotificationRequest request) {
        this.lastRequest = request;
        if (log.isTraceEnabled()) {
            log.trace(new SendNotificationRequestJsonBuilder().toJson(request, SendNotificationRequest.Status.READY));
        } else {
            log.debug("Notification {}:{}", (Object)this.lastRequest.getTopic(), (Object)this.lastRequest.getSummary());
        }
        SendNotificationResponse response = SendNotificationResponse.newSuccess(request);
        this.callbacks.callSuccess(response);
        return CompletableFuture.completedFuture(response);
    }

    public SendNotificationRequest getLastRequest() {
        return this.lastRequest;
    }

    public void clearLast() {
        this.lastRequest = null;
    }
}

