/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.sender.couch;

import java.util.LinkedHashMap;
import java.util.Map;

class JsonParser {
    public Map<String, String> parse(String text) {
        int pos = text.indexOf("{");
        if (pos < 0) {
            throw new IllegalArgumentException("Unable to find starting { in JSON text.");
        }
        return this.split(text, 0);
    }

    protected Map<String, String> split(String text, int start) {
        int marker = 0;
        String lastKey = null;
        ReaderState state = ReaderState.none;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        block0: for (int i = start; i < text.length(); ++i) {
            char curr = text.charAt(i);
            if (state.isNone()) {
                if (curr != '\"') continue;
                marker = i + 1;
                state = ReaderState.inKey;
                continue;
            }
            if (state.isInKey()) {
                if (curr != '\"') continue;
                lastKey = text.substring(marker, i);
                state = ReaderState.afterKey;
                continue;
            }
            if (state.isAfterKey()) {
                if (curr != ':') continue;
                state = ReaderState.beforeValue;
                continue;
            }
            if (state.isBeforeValue()) {
                if (curr == '\"') {
                    marker = i + 1;
                    state = ReaderState.inString;
                    continue;
                }
                if (curr == '{') {
                    marker = i;
                    state = ReaderState.inObject;
                    continue;
                }
                if (Character.isWhitespace(curr)) continue;
                state = ReaderState.inNumber;
                continue;
            }
            if (state.isInString()) {
                if (curr != '\"' || text.charAt(i - 1) == '\\') continue;
                String lastValue = text.substring(marker, i);
                map.put(lastKey, lastValue);
                state = ReaderState.afterValue;
                continue;
            }
            if (state.isInNumber()) {
                if (curr != ',' && !Character.isWhitespace(curr)) continue;
                String lastValue = text.substring(marker, i);
                map.put(lastKey, lastValue);
                state = ReaderState.afterValue;
                continue;
            }
            if (state.isInObject()) {
                int brackets = 1;
                while (i < text.length()) {
                    curr = text.charAt(i);
                    if (curr == '{') {
                        ++brackets;
                    } else if (curr == '}') {
                        --brackets;
                    }
                    if (brackets == 0) {
                        String lastValue = text.substring(marker, i + 1);
                        map.put(lastKey, lastValue);
                        state = ReaderState.afterValue;
                        continue block0;
                    }
                    ++i;
                }
                continue;
            }
            if (!state.isAfterValue() || curr != ',') continue;
            state = ReaderState.none;
        }
        return map;
    }

    private static enum ReaderState {
        none,
        inKey,
        afterKey,
        beforeValue,
        inString,
        inObject,
        inNumber,
        afterValue;


        public boolean isNone() {
            return this == none;
        }

        public boolean isInKey() {
            return this == inKey;
        }

        public boolean isAfterKey() {
            return this == afterKey;
        }

        public boolean isBeforeValue() {
            return this == beforeValue;
        }

        public boolean isInString() {
            return this == inString;
        }

        public boolean isInObject() {
            return this == inObject;
        }

        public boolean isInNumber() {
            return this == inNumber;
        }

        public boolean isAfterValue() {
            return this == afterValue;
        }
    }
}

