/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.sender.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.notify.sender.http.SslException;

public class SslConfig {
    private static final Logger log = LoggerFactory.getLogger(SslConfig.class);
    private final SSLContext sslContext;
    private final SSLSocketFactory sslSocketFactory;
    private final KeyStore keyStore;

    public SslConfig(String keyStoreURI, String keyStorePass) throws SslException {
        try {
            keyStoreURI = keyStoreURI.replaceAll("(\\\\+)+", "/");
            this.keyStore = this.initKeyStore(new URI(keyStoreURI), keyStorePass);
        }
        catch (URISyntaxException e) {
            throw new SslException("Exception creating URI for " + keyStoreURI, e);
        }
        try {
            TrustManagerFactory tmf = this.newTrustManagerFactory();
            this.sslContext = SSLContext.getInstance("TLS");
            this.sslContext.init(new KeyManager[0], tmf.getTrustManagers(), null);
            this.sslSocketFactory = this.sslContext.getSocketFactory();
        }
        catch (Exception ex) {
            log.error("Error initializing SSl Socket Factory.", (Throwable)ex);
            throw new SslException("Exception initializing SSLContext.", ex);
        }
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    protected KeyStore initKeyStore(URI keyStoreURI, String keyStorePass) throws SslException {
        InputStream inputStream = null;
        try {
            KeyStore localKeyStore = KeyStore.getInstance("JKS");
            if (keyStoreURI.getScheme() == null) {
                throw new SslException("KeyStoreURI schema is null, please specify schema (file:, classpath:, etc.).");
            }
            if (keyStoreURI.getScheme().equalsIgnoreCase("classpath")) {
                URL url = this.getClass().getResource(keyStoreURI.getPath());
                if (url == null) {
                    throw new SslException("Could not find keystore file at " + keyStoreURI);
                }
                inputStream = url.openStream();
            } else {
                inputStream = keyStoreURI.toURL().openStream();
            }
            localKeyStore.load(inputStream, keyStorePass.toCharArray());
            KeyStore keyStore = localKeyStore;
            return keyStore;
        }
        catch (Exception ex) {
            log.error("Exception loading keystore.", (Throwable)ex);
            throw new SslException("Exception loading keystore.", ex);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("Error closing input stream in SslSetup", (Throwable)e);
                }
            }
        }
    }

    protected TrustManagerFactory newTrustManagerFactory() throws SslException {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(this.keyStore);
            return tmf;
        }
        catch (Exception ex) {
            throw new SslException("Exception initializing SSLContext in PaymentSubSystem.", ex);
        }
    }
}

