/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.sender.http;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.notify.notifier.NotifierException;
import org.tiogasolutions.notify.notifier.send.SendNotificationRequest;
import org.tiogasolutions.notify.notifier.send.SendNotificationRequestJsonBuilder;
import org.tiogasolutions.notify.notifier.send.SendNotificationResponse;
import org.tiogasolutions.notify.sender.http.HttpNotificationSender;
import org.tiogasolutions.notify.sender.http.HttpNotificationSenderConfig;

public class SimpleHttpNotificationSender
extends HttpNotificationSender {
    private static final Logger log = LoggerFactory.getLogger(SimpleHttpNotificationSender.class);

    public SimpleHttpNotificationSender(HttpNotificationSenderConfig config) {
        super(config);
        log.info("Configured SimpleHttpNotificationSender for " + this.getBaseUrl());
    }

    @Override
    public Future<SendNotificationResponse> send(SendNotificationRequest request) {
        Callable<SendNotificationResponse> callable = () -> {
            Response sendResponse;
            try {
                sendResponse = this.sendRequest(request, SendNotificationRequest.Status.READY);
            }
            catch (Exception t) {
                SendNotificationResponse notificationResponse = SendNotificationResponse.newFailure((SendNotificationRequest)request, (Throwable)t);
                this.callbacks.callFailure(notificationResponse);
                log.error("Failure sending notification request: ", (Throwable)t);
                return notificationResponse;
            }
            int status = sendResponse.getStatus();
            if (status == 200 || status == 201) {
                SendNotificationResponse notificationResponse = SendNotificationResponse.newSuccess((SendNotificationRequest)request);
                this.callbacks.callSuccess(notificationResponse);
                return notificationResponse;
            }
            NotifierException ex = new NotifierException("Non successful response from send: " + sendResponse.getStatus());
            SendNotificationResponse notificationResponse = SendNotificationResponse.newFailure((SendNotificationRequest)request, (Throwable)ex);
            this.callbacks.callFailure(notificationResponse);
            return notificationResponse;
        };
        return this.getExecutorService().submit(callable);
    }

    @Override
    protected Response sendRequest(SendNotificationRequest request, SendNotificationRequest.Status status) {
        String json = new SendNotificationRequestJsonBuilder().toJson(request, status);
        Entity entity = Entity.entity((Object)json, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        WebTarget webTarget = this.getClient().target(this.getBaseUrl());
        return webTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Content-Type", (Object)MediaType.APPLICATION_JSON_TYPE).post(entity);
    }
}

