/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.apis.cloudfoundry.pub;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import org.tiogasolutions.apis.cloudfoundry.pub.Metadata;

public class Event
implements Comparable<Event> {
    private final String type;
    private final String actor;
    private final String actorType;
    private final String actorName;
    private final String actee;
    private final String acteeType;
    private final String acteeName;
    private final ZonedDateTime timestamp;
    private final Metadata metadata;
    private final String spaceGuid;
    private final String organizationGuid;

    public Event(@JsonProperty(value="type") String type, @JsonProperty(value="actor") String actor, @JsonProperty(value="actor_type") String actorType, @JsonProperty(value="actor_name") String actorName, @JsonProperty(value="actee") String actee, @JsonProperty(value="actee_type") String acteeType, @JsonProperty(value="actee_name") String acteeName, @JsonProperty(value="timestamp") ZonedDateTime timestamp, @JsonProperty(value="metadata") Metadata metadata, @JsonProperty(value="space_guid") String spaceGuid, @JsonProperty(value="organization_guid") String organizationGuid) {
        this.type = type;
        this.actor = actor;
        this.actorType = actorType;
        this.actorName = actorName;
        this.actee = actee;
        this.acteeType = acteeType;
        this.acteeName = acteeName;
        this.timestamp = timestamp;
        this.metadata = metadata;
        this.spaceGuid = spaceGuid;
        this.organizationGuid = organizationGuid;
    }

    public String getAction() {
        try {
            return this.getMetadata().getRequest().getState();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public String getType() {
        return this.type;
    }

    public String getActor() {
        return this.actor;
    }

    public String getActorType() {
        return this.actorType;
    }

    public String getActorName() {
        return this.actorName;
    }

    public String getActee() {
        return this.actee;
    }

    public String getActeeType() {
        return this.acteeType;
    }

    public String getActeeName() {
        return this.acteeName;
    }

    public ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public String getSpaceGuid() {
        return this.spaceGuid;
    }

    public String getOrganizationGuid() {
        return this.organizationGuid;
    }

    @Override
    public int compareTo(Event that) {
        int diff = this.timestamp.compareTo(that.timestamp);
        if (diff != 0) {
            return diff;
        }
        diff = this.type.compareTo(that.type);
        if (diff != 0) {
            return diff;
        }
        diff = this.actee.compareTo(that.actee);
        if (diff != 0) {
            return diff;
        }
        diff = this.actor.compareTo(that.actor);
        return diff;
    }

    public String toString() {
        return String.format("%s %s %s", this.acteeName, this.type, this.timestamp);
    }
}

