/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.apis.cloudfoundry.pub;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.SortedSet;
import java.util.TreeSet;
import org.tiogasolutions.apis.cloudfoundry.pub.Event;
import org.tiogasolutions.apis.cloudfoundry.pub.EventResource;

public class GetEventsResponse {
    private final int totalResults;
    private final int totalPages;
    private final String prevUrl;
    private final String nextUrl;
    private final SortedSet<EventResource> eventResources;

    public GetEventsResponse(@JsonProperty(value="total_results") int totalResults, @JsonProperty(value="total_pages") int totalPages, @JsonProperty(value="prev_url") String prevUrl, @JsonProperty(value="next_url") String nextUrl, @JsonProperty(value="resources") TreeSet<EventResource> eventResources) {
        this.totalResults = totalResults;
        this.totalPages = totalPages;
        this.prevUrl = prevUrl;
        this.nextUrl = nextUrl;
        this.eventResources = eventResources;
    }

    public int getTotalResults() {
        return this.totalResults;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public String getPrevUrl() {
        return this.prevUrl;
    }

    public String getNextUrl() {
        return this.nextUrl;
    }

    public SortedSet<EventResource> getEventResources() {
        return this.eventResources;
    }

    public SortedSet<Event> getAppEvents(String appName) {
        TreeSet<Event> events = new TreeSet<Event>();
        for (EventResource resource : this.eventResources) {
            Event event = resource.getEvent();
            if (!"app".equals(event.getActeeType()) || !appName.equals(event.getActeeName())) continue;
            events.add(event);
        }
        return events;
    }
}

