/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.lib.jaxrs.client;

import java.io.UnsupportedEncodingException;
import javax.xml.bind.DatatypeConverter;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.lib.jaxrs.client.Authorization;

public class BasicAuthorization
implements Authorization {
    private final String username;
    private final String password;

    public BasicAuthorization(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public String getHeaderValue() {
        try {
            String token = this.username + ":" + this.password;
            return "Basic " + DatatypeConverter.printBase64Binary((byte[])token.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new UnsupportedOperationException("Cannot encode with UTF-8", ex);
        }
    }

    public static String parseUserFromAuth(String authentication) {
        if (StringUtils.isBlank((Object)authentication)) {
            return null;
        }
        int pos = authentication.indexOf(":");
        if (pos < 0) {
            return authentication;
        }
        String name = authentication.substring(0, pos);
        return StringUtils.isNotBlank((Object)name) ? name : null;
    }

    public static String parsePassFromAuth(String authentication) {
        if (StringUtils.isBlank((Object)authentication)) {
            return null;
        }
        int pos = authentication.indexOf(":");
        if (pos < 0) {
            return null;
        }
        String pass = authentication.substring(pos + 1);
        return StringUtils.isNotBlank((Object)pass) ? pass : null;
    }

    public static String parseBasicAuth(Object url) {
        String left;
        int pos;
        if (StringUtils.isBlank((Object)url)) {
            return null;
        }
        String urlString = url.toString();
        if (urlString.toLowerCase().startsWith("http://")) {
            pos = 7;
        } else if (urlString.toLowerCase().startsWith("https://")) {
            pos = 8;
        } else {
            String msg = "Unable to parse the specified URL - does not start with \"http://\" or \"https://\".";
            throw new IllegalArgumentException(msg);
        }
        String contents = urlString.substring(pos);
        pos = contents.indexOf("/");
        if (pos < 0) {
            pos = contents.length();
        }
        if ((pos = (left = contents.substring(0, pos)).indexOf("@")) < 0) {
            return null;
        }
        return left.substring(0, pos);
    }

    public static String removeBasicAuth(Object url) {
        if (StringUtils.isBlank((Object)url)) {
            return null;
        }
        String urlString = url.toString();
        String auth = BasicAuthorization.parseBasicAuth(urlString);
        if (StringUtils.isBlank((Object)auth)) {
            return urlString;
        }
        if (urlString.toLowerCase().startsWith("http://")) {
            return urlString.replace("http://" + auth + "@", "http://");
        }
        if (urlString.toLowerCase().startsWith("https://")) {
            return urlString.replace("https://" + auth + "@", "https://");
        }
        String msg = "Unable to parse the specified URL - does not start with \"http://\" or \"https://\".";
        throw new IllegalArgumentException(msg);
    }

    public static BasicAuthorization fromUrl(Object url) {
        String auth = BasicAuthorization.parseBasicAuth(url);
        if (auth == null) {
            return null;
        }
        String username = BasicAuthorization.parseUserFromAuth(auth);
        String password = BasicAuthorization.parsePassFromAuth(auth);
        return new BasicAuthorization(username, password);
    }
}

