/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.apis.cloudfoundry;

import java.util.SortedSet;
import javax.ws.rs.core.Form;
import org.tiogasolutions.apis.cloudfoundry.pub.Event;
import org.tiogasolutions.apis.cloudfoundry.pub.GetAppsResponse;
import org.tiogasolutions.apis.cloudfoundry.pub.GetEventsResponse;
import org.tiogasolutions.apis.cloudfoundry.pub.LoginResponse;
import org.tiogasolutions.dev.common.json.JsonTranslator;
import org.tiogasolutions.dev.jackson.TiogaJacksonTranslator;
import org.tiogasolutions.lib.jaxrs.client.Authorization;
import org.tiogasolutions.lib.jaxrs.client.BasicAuthorization;
import org.tiogasolutions.lib.jaxrs.client.BearerAuthorization;
import org.tiogasolutions.lib.jaxrs.client.SimpleRestClient;

public class CfClient {
    private TiogaJacksonTranslator translator = new TiogaJacksonTranslator();
    private SimpleRestClient loginClient = new SimpleRestClient((JsonTranslator)this.translator, (Object)"https://login.run.pivotal.io", (Authorization)new BasicAuthorization("cf", ""));
    private SimpleRestClient apiClient = new SimpleRestClient((JsonTranslator)this.translator, (Object)"https://api.run.pivotal.io");
    private String refreshToken;

    public BasicAuthorization getLoginAuthorization() {
        return (BasicAuthorization)this.loginClient.getAuthorization();
    }

    public BearerAuthorization getApiAuthorization() {
        return (BearerAuthorization)this.apiClient.getAuthorization();
    }

    public void setIgnoringCertificates(boolean ignoringCertificates) {
        this.apiClient.setIgnoringCertificates(ignoringCertificates);
        this.loginClient.setIgnoringCertificates(ignoringCertificates);
    }

    public LoginResponse login(String emailAddress, String password) {
        Form form = new Form();
        form.param("grant_type", "password");
        form.param("username", emailAddress);
        form.param("password", password);
        LoginResponse response = (LoginResponse)this.loginClient.post(LoginResponse.class, "/oauth/token", (Object)form);
        this.refreshToken = response.getRefreshToken();
        String accessToken = response.getAccessToken();
        this.apiClient.setAuthorization((Authorization)new BearerAuthorization(accessToken));
        return response;
    }

    public LoginResponse refresh() {
        Form form = new Form();
        form.param("grant_type", "refresh_token");
        form.param("refresh_token", this.refreshToken);
        LoginResponse response = (LoginResponse)this.loginClient.post(LoginResponse.class, "/oauth/token", (Object)form);
        this.refreshToken = response.getRefreshToken();
        String accessToken = response.getAccessToken();
        this.apiClient.setAuthorization((Authorization)new BearerAuthorization(accessToken));
        return response;
    }

    public SortedSet<Event> getApplicatinEvents(String appName, int max) {
        GetEventsResponse response = this.getApplicationEvents(max);
        return response.getAppEvents(appName);
    }

    public GetEventsResponse getApplicationEvents(int max) {
        if (max < 1) {
            max = 100;
        }
        max = Math.min(100, max);
        String resultsPerPage = "results-per-page=" + max;
        String orderDirection = "order-direction=desc";
        return (GetEventsResponse)this.apiClient.get(GetEventsResponse.class, "/v2/events", new String[]{resultsPerPage, orderDirection});
    }

    public GetAppsResponse getApplications() {
        return (GetAppsResponse)this.apiClient.get(GetAppsResponse.class, "/v2/apps", new String[0]);
    }
}

