/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.notifier.builder;

import java.util.ArrayList;
import java.util.List;
import org.tiogasolutions.notify.notifier.builder.NotificationBuilder;
import org.tiogasolutions.notify.notifier.builder.NotificationBuilderCallback;

public class NotificationBuilderCallbacks {
    private final List<NotificationBuilderCallback> onBeginCallbacks = new ArrayList<NotificationBuilderCallback>();
    private final List<NotificationBuilderCallback> beforeSendCallbacks = new ArrayList<NotificationBuilderCallback>();

    public NotificationBuilderCallbacks() {
    }

    public NotificationBuilderCallbacks(NotificationBuilderCallbacks callbacks) {
        this.onBeginCallbacks.addAll(callbacks.onBeginCallbacks);
        this.beforeSendCallbacks.addAll(callbacks.beforeSendCallbacks);
    }

    public NotificationBuilderCallbacks copy() {
        return new NotificationBuilderCallbacks(this);
    }

    public void onBegin(NotificationBuilderCallback callback) {
        this.onBeginCallbacks.add(callback);
    }

    public void onBeforeSend(NotificationBuilderCallback callback) {
        this.beforeSendCallbacks.add(callback);
    }

    public void callBegin(NotificationBuilder builder) {
        this.onBeginCallbacks.stream().forEachOrdered(c -> c.call(builder));
    }

    public void callBeforeSend(NotificationBuilder builder) {
        this.beforeSendCallbacks.stream().forEachOrdered(c -> c.call(builder));
    }

    protected List<NotificationBuilderCallback> getOnBeginCallbacks() {
        return this.onBeginCallbacks;
    }

    protected List<NotificationBuilderCallback> getBeforeSendCallbacks() {
        return this.beforeSendCallbacks;
    }
}

