/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.dev.common.exceptions;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.tiogasolutions.dev.common.ReflectUtils;
import org.tiogasolutions.dev.common.StringUtils;

public class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static Path assertIsFile(Path path) throws IOException {
        ExceptionUtils.assertIsFile(path.toFile());
        return path;
    }

    public static File assertIsFile(File file) throws IOException {
        ExceptionUtils.assertExists(file);
        if (!file.isFile()) {
            String msg = String.format("The path \"%s\" is not a file.", file.getAbsolutePath());
            throw new IOException(msg);
        }
        return file;
    }

    public static Path assertIsDirectory(Path path) throws IOException {
        ExceptionUtils.assertIsDirectory(path.toFile());
        return path;
    }

    public static File assertIsDirectory(File file) throws IOException {
        ExceptionUtils.assertExists(file);
        if (!file.isDirectory()) {
            String msg = String.format("The path \"%s\" is not a directory.", file.getAbsolutePath());
            throw new IOException(msg);
        }
        return file;
    }

    public static Path assertExists(Path path) throws FileNotFoundException {
        ExceptionUtils.assertExists(path.toFile());
        return path;
    }

    public static File assertExists(File file) throws FileNotFoundException {
        if (!file.exists()) {
            String msg = String.format("The path \"%s\" does not exist.", file.getAbsolutePath());
            throw new FileNotFoundException(msg);
        }
        return file;
    }

    public static String assertNotZeroLength(String value, String name) {
        if (value == null) {
            String msg = String.format("The value \"%s\" cannot be null.", name);
            throw new NullPointerException(msg);
        }
        if (value.isEmpty()) {
            String msg = String.format("The value \"%s\" is an empty string.", name);
            throw new NullPointerException(msg);
        }
        return value;
    }

    public static <T> T assertNotNull(T value, String name) {
        if (value == null) {
            String msg = String.format("The value \"%s\" cannot be null.", name);
            throw ExceptionUtils.trimStackTrace(new NullPointerException(msg));
        }
        return value;
    }

    public static <T> T[] assertNotEmpty(T[] value, String name) {
        ExceptionUtils.assertNotNull(value, name);
        if (value.length == 0) {
            String msg = String.format("The value \"%s\" cannot be empty.", name);
            throw ExceptionUtils.trimStackTrace(new NullPointerException(msg));
        }
        return value;
    }

    public static <T> Collection<T> assertNotEmpty(Collection<T> value, String name) {
        ExceptionUtils.assertNotNull(value, name);
        if (value.size() == 0) {
            String msg = String.format("The value \"%s\" cannot be empty.", name);
            throw ExceptionUtils.trimStackTrace(new NullPointerException(msg));
        }
        return value;
    }

    public static long assertPositive(long value, String name) {
        if (value <= 0L) {
            String msg = String.format("The value \"%s\" cannot be less than zero.", name);
            throw ExceptionUtils.trimStackTrace(new IllegalArgumentException(msg));
        }
        return value;
    }

    public static long assertNegative(long value, String name) {
        if (value >= 0L) {
            String msg = String.format("The value \"%s\" cannot be greater than zero.", name);
            throw ExceptionUtils.trimStackTrace(new IllegalArgumentException(msg));
        }
        return value;
    }

    private static <T extends Throwable> T trimStackTrace(T ex) {
        ArrayList elements = new ArrayList();
        Collections.addAll(elements, ex.getStackTrace());
        elements.remove(0);
        ex.setStackTrace(ReflectUtils.toArray(StackTraceElement.class, elements));
        return ex;
    }

    public static String toString(Throwable e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    public static Throwable getRootCause(Throwable e) {
        Throwable cause = e.getCause();
        while (cause != null && cause != e) {
            e = cause;
            cause = e.getCause();
        }
        return e;
    }

    public static String getMessage(Throwable ex) {
        String msg = ex.getMessage();
        return StringUtils.isBlank(msg) ? ex.getClass().getName() : msg;
    }

    public static String getRootMessage(Throwable ex) {
        String msg = (ex = ExceptionUtils.getRootCause(ex)).getMessage();
        return StringUtils.isBlank(msg) ? ex.getClass().getName() : msg;
    }

    public static String getStackTrace(Throwable e) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        e.printStackTrace(pw);
        return writer.toString();
    }

    public static List<? extends Throwable> getRootCauses(Throwable e) {
        Throwable last = e.getCause();
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        list.add(e);
        while (last != e && last != null) {
            list.add(last);
            e = last;
            last = e.getCause();
        }
        return list;
    }
}

