/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.notifier.send;

import java.util.ArrayList;
import java.util.List;
import org.tiogasolutions.notify.notifier.send.NotificationAttachment;
import org.tiogasolutions.notify.notifier.send.NotificationAttachmentFailureCallback;
import org.tiogasolutions.notify.notifier.send.NotificationResponseCallback;
import org.tiogasolutions.notify.notifier.send.SendNotificationRequest;
import org.tiogasolutions.notify.notifier.send.SendNotificationResponse;

public class NotificationSenderCallbacks {
    private final List<NotificationResponseCallback> responseCallbacks = new ArrayList<NotificationResponseCallback>();
    private final List<NotificationResponseCallback> successCallbacks = new ArrayList<NotificationResponseCallback>();
    private final List<NotificationResponseCallback> failureCallbacks = new ArrayList<NotificationResponseCallback>();
    private final List<NotificationAttachmentFailureCallback> attachmentFailureCallbacks = new ArrayList<NotificationAttachmentFailureCallback>();

    public void onResponse(NotificationResponseCallback callback) {
        this.responseCallbacks.add(callback);
    }

    public void onSuccess(NotificationResponseCallback callback) {
        this.successCallbacks.add(callback);
    }

    public void onFailure(NotificationResponseCallback callback) {
        this.failureCallbacks.add(callback);
    }

    public void onFailure(NotificationAttachmentFailureCallback callback) {
        this.attachmentFailureCallbacks.add(callback);
    }

    public void callResponse(SendNotificationResponse response) {
        this.responseCallbacks.stream().forEachOrdered(c -> c.call(response));
    }

    public void callSuccess(SendNotificationResponse response) {
        this.successCallbacks.stream().forEachOrdered(c -> c.call(response));
        this.callResponse(response);
    }

    public void callFailure(SendNotificationResponse response) {
        this.failureCallbacks.stream().forEachOrdered(c -> c.call(response));
    }

    public void callFailure(SendNotificationRequest request, NotificationAttachment attachment, Throwable t) {
        this.attachmentFailureCallbacks.stream().forEachOrdered(c -> c.call(request, attachment, t));
    }
}

