/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.lib.jaxrs.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.tiogasolutions.dev.common.MapBuilder;
import org.tiogasolutions.dev.common.exceptions.ExceptionUtils;
import org.tiogasolutions.dev.domain.query.QueryResult;

public class RestQueryResult<T>
implements QueryResult<T> {
    private final Class<? extends T> containsType;
    private final int limit;
    private final int offset;
    private int totalFound;
    private boolean totalExact;
    private final List<T> results;
    private final Map<String, URI> links;

    private RestQueryResult(UriInfo uriInfo, String path, Class<? extends T> containsType, int limit, int offset, int totalFound, boolean totalExact, Collection<T> results) {
        URI last;
        URI next;
        URI prev;
        URI first;
        this.containsType = containsType;
        this.limit = limit;
        this.offset = offset;
        this.totalFound = totalFound;
        this.totalExact = totalExact;
        ArrayList<T> list = new ArrayList<T>(results);
        this.results = Collections.unmodifiableList(list);
        URI self = this.build(uriInfo, path, offset, limit);
        if (results.isEmpty()) {
            first = null;
            prev = null;
            next = null;
            last = null;
        } else {
            first = this.build(uriInfo, path, 0, limit);
            last = !totalExact ? null : this.build(uriInfo, path, totalFound - limit, limit);
            int prevPage = Math.min(Math.max(0, offset - limit), totalFound - 1);
            prev = offset == 0 ? null : this.build(uriInfo, path, prevPage, limit);
            int nextPage = offset + limit;
            next = offset + results.size() >= totalFound ? null : this.build(uriInfo, path, nextPage, limit);
        }
        this.links = new MapBuilder(String.class, URI.class).put((Object)"self", (Object)self).put((Object)"first", (Object)first).put((Object)"prev", prev).put((Object)"next", next).put((Object)"last", (Object)last).buildLinkedHashMap();
    }

    protected URI build(UriInfo uriInfo, String path, int offset, int limit) {
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        return uriBuilder.path(path).replaceQueryParam("offset", new Object[]{offset}).replaceQueryParam("limit", new Object[]{limit}).build(new Object[0]);
    }

    public Map<String, URI> getLinks() {
        return this.links;
    }

    public Class<? extends T> getContainsType() {
        return this.containsType;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getTotalFound() {
        return this.totalFound;
    }

    public boolean isTotalExact() {
        return this.totalExact;
    }

    public List<T> getResults() {
        return this.results;
    }

    @JsonIgnore
    public boolean isContainsType(Class<?> containsType) {
        return this.containsType.isAssignableFrom(containsType);
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.results.isEmpty();
    }

    @JsonIgnore
    public boolean isNotEmpty() {
        return !this.results.isEmpty();
    }

    @JsonIgnore
    public int getSize() {
        return this.results.size();
    }

    @JsonIgnore
    public boolean getHasPrevious() {
        return this.offset != 0;
    }

    @JsonIgnore
    public boolean getHasNext() {
        return this.offset + this.results.size() < this.totalFound;
    }

    @JsonIgnore
    public T getFirst() {
        return this.results.get(0);
    }

    @JsonIgnore
    public T getLast() {
        return this.results.get(this.results.size() - 1);
    }

    public T getAt(int index) {
        return this.results.get(index);
    }

    public Iterator<T> iterator() {
        return this.results.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestQueryResult that = (RestQueryResult)o;
        if (this.limit != that.limit) {
            return false;
        }
        if (this.offset != that.offset) {
            return false;
        }
        if (this.totalFound != that.totalFound) {
            return false;
        }
        if (this.results.size() != that.results.size()) {
            return false;
        }
        if (!this.results.equals(that.results)) {
            return false;
        }
        if (!this.containsType.equals(that.containsType)) {
            return false;
        }
        return this.links.equals(that.links);
    }

    public int hashCode() {
        int result = this.containsType.hashCode();
        result = 31 * result + this.offset;
        result = 31 * result + this.limit;
        result = 31 * result + this.totalFound;
        result = 31 * result + this.results.hashCode();
        result = 31 * result + this.links.hashCode();
        return result;
    }

    public String toString() {
        return "JaxRsQueryResult{type=" + this.containsType + ", limit=" + this.limit + ", offset=" + this.offset + ", totalFound=" + this.totalFound + ", results=" + this.results + ", links=" + this.links + '}';
    }

    public static <T> RestQueryResult<T> from(UriInfo uriInfo, String path, QueryResult<T> queryResult) {
        return RestQueryResult.newResult(uriInfo, path, queryResult.getContainsType(), queryResult.getLimit(), queryResult.getOffset(), queryResult.getTotalFound(), queryResult.isTotalExact(), queryResult.getResults());
    }

    public static <T> RestQueryResult<T> newEmpty(UriInfo uriInfo, String path, Class<T> containsType) {
        return new RestQueryResult<T>(uriInfo, path, containsType, 0, 0, 0, true, Collections.emptyList());
    }

    public static <T> RestQueryResult<T> newSingle(UriInfo uriInfo, String path, Class<T> containsType, T result) {
        ExceptionUtils.assertNotNull(result, (String)"result");
        return RestQueryResult.newResult(uriInfo, path, containsType, 1, 0, 1, true, Collections.singleton(result));
    }

    @SafeVarargs
    public static <T> RestQueryResult<T> newComplete(UriInfo uriInfo, String path, Class<T> containsType, T ... results) {
        return RestQueryResult.newComplete(uriInfo, path, containsType, Arrays.asList(results));
    }

    public static <T> RestQueryResult<T> newComplete(UriInfo uriInfo, String path, Class<T> containsType, Collection<T> results) {
        return RestQueryResult.newResult(uriInfo, path, containsType, results.size(), 0, results.size(), true, results);
    }

    @SafeVarargs
    public static <T> RestQueryResult<T> newResult(UriInfo uriInfo, String path, Class<? extends T> containsType, int limit, int offset, int totalFound, boolean totalExact, T ... results) {
        return RestQueryResult.newResult(uriInfo, path, containsType, limit, offset, totalFound, totalExact, Arrays.asList(results));
    }

    public static <T> RestQueryResult<T> newResult(UriInfo uriInfo, String path, Class<? extends T> containsType, int limit, int offset, int totalFound, boolean totalExact, Collection<T> results) {
        return new RestQueryResult<T>(uriInfo, path, containsType, limit, offset, totalFound, totalExact, results);
    }
}

