/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.lib.jaxrs.providers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;
import org.tiogasolutions.dev.common.DateUtils;

@Provider
public class JavaTimeParamConverterProvider
implements ParamConverterProvider {
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (LocalDate.class.equals(rawType)) {
            return new LocalDateParamConverter(rawType);
        }
        if (LocalTime.class.equals(rawType)) {
            return new LocalTimeParamConverter<T>(rawType);
        }
        if (LocalDateTime.class.equals(rawType)) {
            return new LocalDateTimeParamConverter<T>(rawType);
        }
        if (ZonedDateTime.class.equals(rawType)) {
            return new ZonedDateTimeParamConverter<T>(rawType);
        }
        return null;
    }

    public class ZonedDateTimeParamConverter<T>
    implements ParamConverter<T> {
        private final Class<T> rawType;

        public ZonedDateTimeParamConverter(Class<T> rawType) {
            this.rawType = rawType;
        }

        public T fromString(String value) {
            return value == null ? null : (T)this.rawType.cast(DateUtils.toZonedDateTime((String)value));
        }

        public String toString(T value) {
            return value == null ? "" : value.toString();
        }
    }

    public class LocalTimeParamConverter<T>
    implements ParamConverter<T> {
        private final Class<T> rawType;

        public LocalTimeParamConverter(Class<T> rawType) {
            this.rawType = rawType;
        }

        public T fromString(String value) {
            return value == null ? null : (T)this.rawType.cast(DateUtils.toLocalTime((String)value));
        }

        public String toString(T value) {
            return value == null ? "" : value.toString();
        }
    }

    public class LocalDateTimeParamConverter<T>
    implements ParamConverter<T> {
        private final Class<T> rawType;

        public LocalDateTimeParamConverter(Class<T> rawType) {
            this.rawType = rawType;
        }

        public T fromString(String value) {
            return value == null ? null : (T)this.rawType.cast(DateUtils.toLocalDateTime((String)value));
        }

        public String toString(T value) {
            return value == null ? "" : value.toString();
        }
    }

    private static class LocalDateParamConverter<T>
    implements ParamConverter<T> {
        private final Class<T> rawType;

        private LocalDateParamConverter(Class<T> rawType) {
            this.rawType = rawType;
        }

        public T fromString(String value) {
            return value == null ? null : (T)this.rawType.cast(DateUtils.toLocalDate((String)value));
        }

        public String toString(T value) {
            return value == null ? "" : value.toString();
        }
    }
}

