/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.lib.jaxrs.providers;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.dev.common.net.HttpStatusCode;
import org.tiogasolutions.lib.jaxrs.domain.TiogaExceptionInfo;

public abstract class TiogaJaxRsExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger log = LoggerFactory.getLogger(TiogaJaxRsExceptionMapper.class);
    @Context
    protected UriInfo uriInfo;
    private final Map<Class<?>, Integer> exceptionMap = new HashMap();

    public TiogaJaxRsExceptionMapper() {
        log.info("Created.");
    }

    public void registerException(HttpStatusCode httpStatus, Class<?> ... types) {
        this.registerException(httpStatus.getCode(), types);
    }

    public void registerException(int httpStatus, Class<?> ... types) {
        for (Class<?> type : types) {
            this.exceptionMap.put(type, httpStatus);
        }
    }

    public Response toResponse(Throwable ex) {
        WebApplicationException wae;
        if (this.exceptionMap.containsKey(ex.getClass())) {
            int status = this.exceptionMap.get(ex.getClass());
            return this.toResponse(status, ex);
        }
        if (ex instanceof ApiException) {
            ApiException apiEx = (ApiException)ex;
            int status = apiEx.getHttpStatusCode().getCode();
            return this.toResponse(status, ex);
        }
        if (ex instanceof WebApplicationException && (wae = (WebApplicationException)ex).getResponse() != null) {
            int status = wae.getResponse().getStatus();
            return this.toResponse(status, ex);
        }
        return this.toResponse(500, ex);
    }

    protected Response toResponse(int status, Throwable ex) {
        this.logException(ex, status);
        return this.createResponse(status, ex);
    }

    protected Response createResponse(int status, Throwable ex) {
        TiogaExceptionInfo exceptionInfo = new TiogaExceptionInfo(status, ex);
        return Response.status((int)status).entity((Object)exceptionInfo).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    protected void logException(Throwable throwable, int status) {
        String msg = "Status " + status;
        if (this.uriInfo != null) {
            msg = msg + " ";
            msg = msg + this.uriInfo.getRequestUri();
        }
        if (status >= 400 && status < 500) {
            this.log4xxException(msg, throwable);
        } else {
            this.log5xxException(msg, throwable);
        }
    }

    protected void log4xxException(String msg, Throwable throwable) {
        log.info(msg);
    }

    protected void log5xxException(String msg, Throwable throwable) {
        log.error(msg, throwable);
    }
}

