/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.apis.cloudfoundry.pub;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.tiogasolutions.apis.cloudfoundry.pub.App;
import org.tiogasolutions.apis.cloudfoundry.pub.AppResource;

public class GetAppsResponse {
    private final int totalResults;
    private final int totalPages;
    private final String prevUrl;
    private final String nextUrl;
    private final List<AppResource> appResources;

    public GetAppsResponse(@JsonProperty(value="total_results") int totalResults, @JsonProperty(value="total_pages") int totalPages, @JsonProperty(value="prev_url") String prevUrl, @JsonProperty(value="next_url") String nextUrl, @JsonProperty(value="resources") ArrayList<AppResource> appResources) {
        this.totalResults = totalResults;
        this.totalPages = totalPages;
        this.prevUrl = prevUrl;
        this.nextUrl = nextUrl;
        this.appResources = appResources;
    }

    public int getTotalResults() {
        return this.totalResults;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public String getPrevUrl() {
        return this.prevUrl;
    }

    public String getNextUrl() {
        return this.nextUrl;
    }

    public List<AppResource> getAppResources() {
        return this.appResources;
    }

    public List<App> getApplications() {
        ArrayList<App> apps = new ArrayList<App>();
        for (AppResource resource : this.appResources) {
            App app = resource.getApp();
            apps.add(app);
        }
        return apps;
    }
}

