/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.extras.monitor;

import ch.qos.logback.classic.Level;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.apis.cloudfoundry.CfClient;
import org.tiogasolutions.apis.cloudfoundry.pub.Event;
import org.tiogasolutions.apis.cloudfoundry.pub.EventResource;
import org.tiogasolutions.apis.cloudfoundry.pub.GetEventsResponse;
import org.tiogasolutions.app.common.AppUtils;
import org.tiogasolutions.dev.common.EnvUtils;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.dev.common.exceptions.ApiUnauthorizedException;
import org.tiogasolutions.notify.notifier.send.SendNotificationRequest;
import org.tiogasolutions.notify.sender.couch.CouchNotificationSender;

public class TiogaCloudFoundryMonitor
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(TiogaCloudFoundryMonitor.class);
    private final long retention;
    private final CfClient client;
    private final CouchNotificationSender sender;
    private final Map<String, ZonedDateTime> processed = new HashMap<String, ZonedDateTime>();

    public TiogaCloudFoundryMonitor() {
        String value = EnvUtils.findProperty((String)"tioga_monitor_retention", (String)String.valueOf(10));
        this.retention = Long.valueOf(value);
        this.client = new CfClient();
        this.client.login(EnvUtils.requireProperty((String)"tioga_cloud_foundry_username"), EnvUtils.requireProperty((String)"tioga_cloud_foundry_password"));
        String couchUrl = EnvUtils.requireProperty((String)"tioga_monitor_couch_url");
        String couchDb = EnvUtils.requireProperty((String)"tioga_monitor_couch_db");
        String username = EnvUtils.requireProperty((String)"tioga_monitor_couch_username");
        String password = EnvUtils.requireProperty((String)"tioga_monitor_couch_password");
        this.sender = new CouchNotificationSender(couchUrl, couchDb, username, password);
    }

    public static void main(String ... args) {
        AppUtils.initLogback((Level)Level.WARN);
        AppUtils.setLogLevel((Level)Level.INFO, (Class[])new Class[]{TiogaCloudFoundryMonitor.class});
        TiogaCloudFoundryMonitor app = new TiogaCloudFoundryMonitor();
        new Thread(app).start();
    }

    @Override
    public void run() {
        try {
            this.processEvents();
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.flush();
        }
        System.err.flush();
        System.out.flush();
        System.exit(0);
    }

    private void processEvents() throws Exception {
        this.seedProcessedEvents();
        while (true) {
            GetEventsResponse response = this.fetchEvents();
            response.getEventResources().forEach(this::processEvent);
            this.cleanCache();
            Runtime runtime = Runtime.getRuntime();
            String msg = String.format("Cache size: %,d, max memory: %,dMB, total: %,dMB, free: %,dMB", this.processed.size(), runtime.maxMemory() / 1024L / 1024L, runtime.totalMemory() / 1024L / 1024L, runtime.freeMemory() / 1024L / 1024L);
            log.info(msg);
            Thread.sleep(1000L);
        }
    }

    private void processEvent(EventResource resource) {
        String id = resource.getMetadata().getGuid();
        ZonedDateTime createdAt = resource.getMetadata().getCreatedAt();
        Event event = resource.getEvent();
        if (this.processed.containsKey(id)) {
            log.debug("Skipping processed event:\n    Type: {} {}\n    Name: {}\n    Created: {}\n    ID: {}\n", new Object[]{event.getType(), event.getAction(), resource.getEvent().getActeeName(), createdAt, id});
            return;
        }
        if (createdAt.isBefore(ZonedDateTime.now().minusMinutes(this.retention))) {
            log.debug("Skipping old event:\n    Type: {} {}\n    Name: {}\n    Created: {}\n    ID: {}\n", new Object[]{event.getType(), event.getAction(), resource.getEvent().getActeeName(), createdAt, id});
            return;
        }
        this.sendNotification(resource);
        this.processed.put(id, createdAt);
    }

    private void sendNotification(EventResource resource) {
        HashMap<String, String> traits = new HashMap<String, String>();
        String summary = this.buildSummary(resource, traits);
        log.info("Processing event: " + summary);
        SendNotificationRequest request = new SendNotificationRequest(false, "cloud-foundry-events", summary, resource.getMetadata().getGuid(), resource.getEvent().getTimestamp(), traits, Collections.emptyList(), null, Collections.emptyList());
        this.sender.onFailure(response -> {
            String msg = "Failed to send notification for " + resource.getEvent().getActeeName();
            log.error(msg, response.getThrowable());
        });
        this.sender.send(request);
    }

    private String buildSummary(EventResource resource, Map<String, String> traits) {
        Event event = resource.getEvent();
        String summary = String.format("%s %s", resource.getEvent().getActeeName(), event.getType());
        if (event.getAction() != null) {
            summary = summary + " ";
            summary = summary + event.getAction();
            traits.put("action", event.getAction());
        }
        if (resource.getMetadata().getExitDescription() != null) {
            summary = summary + ": ";
            summary = summary + resource.getMetadata().getExitDescription();
            traits.put("exit-description", resource.getMetadata().getExitDescription());
        }
        return summary;
    }

    private GetEventsResponse fetchEvents() throws Exception {
        try {
            log.debug("Fetching events");
            long start = System.currentTimeMillis();
            GetEventsResponse response = this.client.getApplicationEvents(0);
            long duration = System.currentTimeMillis() - start;
            log.debug("Fetched {} events in {} seconds", (Object)response.getEventResources().size(), (Object)(duration / 1000L));
            return response;
        }
        catch (ApiUnauthorizedException e) {
            log.info("Refreshing access token");
            this.client.refresh();
            return this.fetchEvents();
        }
        catch (ApiException ex) {
            Thread.sleep(1000L);
            log.error("Failed to retrieve events", (Throwable)ex);
            return this.fetchEvents();
        }
    }

    private void cleanCache() {
        ArrayList<String> ids = new ArrayList<String>(this.processed.keySet());
        for (String id : ids) {
            ZonedDateTime createdAt = this.processed.get(id);
            if (createdAt == null || !createdAt.isBefore(ZonedDateTime.now().minusMinutes(this.retention))) continue;
            log.debug("Removing old event {} {}", (Object)id, (Object)createdAt);
            this.processed.remove(id);
        }
    }

    private void seedProcessedEvents() throws Exception {
        log.info("Seeding initial list of processed events");
        GetEventsResponse response = this.fetchEvents();
        for (EventResource resource : response.getEventResources()) {
            String id = resource.getMetadata().getGuid();
            ZonedDateTime createdAt = resource.getEvent().getTimestamp();
            this.processed.put(id, createdAt);
        }
        this.cleanCache();
        log.info("Seeding completed, caching {} events", (Object)this.processed.size());
    }
}

