/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.lib.jaxrs.client;

import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.tiogasolutions.dev.common.IoUtils;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.dev.common.json.JsonTranslator;
import org.tiogasolutions.dev.common.net.HttpStatusCode;
import org.tiogasolutions.dev.domain.query.QueryResult;
import org.tiogasolutions.lib.jaxrs.client.Authorization;
import org.tiogasolutions.lib.jaxrs.client.BasicAuthorization;

public class SimpleRestClient {
    protected final String rootUrl;
    protected final JsonTranslator translator;
    protected Authorization authorization;
    protected boolean notFoundToNull;
    protected boolean ignoringCertificates;

    public SimpleRestClient(JsonTranslator translator, Object rootUrl) {
        this(translator, rootUrl, BasicAuthorization.fromUrl(rootUrl));
    }

    @Deprecated
    public SimpleRestClient(JsonTranslator translator, Object rootUrl, String username, String password) {
        this(false, translator, (Object)BasicAuthorization.removeBasicAuth(rootUrl), new BasicAuthorization(username, password));
    }

    public SimpleRestClient(JsonTranslator translator, Object rootUrl, Authorization authorization) {
        this(false, translator, (Object)BasicAuthorization.removeBasicAuth(rootUrl), authorization);
    }

    public SimpleRestClient(boolean notFoundToNull, JsonTranslator translator, Object rootUrl, Authorization authorization) {
        this.rootUrl = rootUrl == null ? null : rootUrl.toString();
        this.authorization = authorization;
        this.translator = translator;
        this.notFoundToNull = notFoundToNull;
    }

    public boolean isNotFoundToNull() {
        return this.notFoundToNull;
    }

    public void setNotFoundToNull(boolean notFoundToNull) {
        this.notFoundToNull = notFoundToNull;
    }

    public void put(String subUrl) {
        this.put(null, subUrl, null);
    }

    public void put(String subUrl, Object entity) {
        this.put(null, subUrl, entity);
    }

    public <T> T put(Class<T> returnType, String subUrl) {
        return this.put(returnType, subUrl, null);
    }

    public <T> T put(Class<T> returnType, String subUrl, Object entity) {
        return this.put(returnType, MediaType.APPLICATION_JSON_TYPE, subUrl, entity, Collections.emptyMap(), new String[0]);
    }

    public <T> T put(Class<T> returnType, MediaType contentType, String subUrl, Object entity, Map<String, Object> headers, String ... acceptedResponseTypes) {
        if (acceptedResponseTypes.length == 0) {
            acceptedResponseTypes = new String[]{"application/json"};
        }
        Invocation.Builder builder = this.builder(subUrl, Collections.emptyMap(), headers, acceptedResponseTypes);
        String json = entity == null ? null : this.translator.toJson(entity);
        Response response = builder.put(Entity.entity((Object)json, (MediaType)contentType));
        return this.translateResponse(returnType, response);
    }

    public void post(String subUrl) {
        this.post(null, subUrl, null);
    }

    public void post(String subUrl, Object entity) {
        this.post(null, subUrl, entity);
    }

    public <T> T post(Class<T> returnType, String subUrl) {
        return this.post(returnType, subUrl, null);
    }

    public <T> T post(Class<T> returnType, String subUrl, Object entity) {
        return this.post(returnType, MediaType.APPLICATION_JSON_TYPE, subUrl, entity, Collections.emptyMap(), new String[0]);
    }

    public <T> T post(Class<T> returnType, MediaType contentType, String subUrl, Object entity, Map<String, Object> headers, String ... acceptedResponseTypes) {
        Response response;
        if (acceptedResponseTypes.length == 0) {
            acceptedResponseTypes = new String[]{"application/json"};
        }
        Invocation.Builder builder = this.builder(subUrl, Collections.emptyMap(), headers, acceptedResponseTypes);
        if (entity instanceof Form) {
            Form form = (Form)entity;
            response = builder.post(Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        } else if (entity instanceof String) {
            String text = entity.toString();
            response = builder.post(Entity.entity((Object)text, (MediaType)contentType));
        } else {
            String json = entity == null ? null : this.translator.toJson(entity);
            response = builder.post(Entity.entity((Object)json, (MediaType)contentType));
        }
        return this.translateResponse(returnType, response);
    }

    public <T> QueryResult<T> getQueryResult(Class<T> returnType, String subUrl, String ... queryStrings) {
        return this.get(QueryResult.class, subUrl, queryStrings);
    }

    public <T> T get(Class<T> returnType, String subUrl, String ... queryStrings) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.putAll(this.toMap(queryStrings));
        return this.get(returnType, subUrl, queryMap, "application/json");
    }

    public <T> T get(Class<T> returnType, String subUrl, Map<String, Object> queryMap) {
        return this.get(returnType, subUrl, queryMap, "application/json");
    }

    public <T> T get(Class<T> returnType, String subUrl, Map<String, Object> queryMap, String ... acceptedResponseTypes) {
        return this.get(returnType, subUrl, queryMap, Collections.emptyMap(), acceptedResponseTypes);
    }

    public <T> T get(Class<T> returnType, String subUrl, Map<String, Object> queryMap, Map<String, Object> headers, String ... acceptedResponseTypes) {
        Invocation.Builder builder = this.builder(subUrl, queryMap, headers, acceptedResponseTypes);
        Response response = (Response)builder.get(Response.class);
        return this.translateResponse(returnType, response);
    }

    public <T> T translateResponse(Class<T> returnType, Response response) {
        if (response.getStatus() == 404 && this.notFoundToNull) {
            return null;
        }
        this.assertResponse(response);
        if (returnType == null) {
            return null;
        }
        if (Response.class.equals(returnType)) {
            return returnType.cast(response);
        }
        String content = (String)response.readEntity(String.class);
        return this.translateResponse(returnType, content);
    }

    public <T> T translateResponse(Class<T> returnType, String content) {
        if (String.class.equals(returnType)) {
            String retValue = content.replaceAll("\r", "");
            return returnType.cast(retValue);
        }
        Object retValue = this.translator.fromJson(returnType, content, new Class[0]);
        return returnType.cast(retValue);
    }

    public byte[] getBytes(String subUrl, Map<String, Object> queryMap, String ... acceptedResponseTypes) throws IOException {
        return this.getBytes(subUrl, queryMap, Collections.emptyMap(), acceptedResponseTypes);
    }

    public byte[] getBytes(String subUrl, Map<String, Object> queryMap, Map<String, Object> headers, String ... acceptedResponseTypes) throws IOException {
        Invocation.Builder builder = this.builder(subUrl, queryMap, headers, acceptedResponseTypes);
        Response response = (Response)builder.get(Response.class);
        InputStream in = (InputStream)response.getEntity();
        byte[] bytes = IoUtils.toBytes((InputStream)in);
        if (response.getStatus() == 404 && this.notFoundToNull) {
            return null;
        }
        this.assertResponse(response.getStatus(), null);
        return bytes;
    }

    public <T> List<T> getList(Class<T> returnType, String subUrl, String ... queryStrings) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.putAll(this.toMap(queryStrings));
        return this.getList(returnType, subUrl, queryMap);
    }

    public <T> List<T> getList(Class<T> returnType, String subUrl, Map<String, Object> queryMap) {
        return this.getList(returnType, subUrl, queryMap, Collections.emptyMap());
    }

    public <T> List<T> getList(Class<T> returnType, String subUrl, Map<String, Object> queryMap, Map<String, Object> headers) {
        Invocation.Builder builder = this.builder(subUrl, queryMap, headers, "application/json");
        Response response = builder.get();
        if (response.getStatus() == 404 && this.notFoundToNull) {
            return null;
        }
        this.assertResponse(response);
        ArrayList<T> list = new ArrayList<T>();
        String content = (String)response.readEntity(String.class);
        for (Object object : (List)this.translator.fromJson(List.class, content, new Class[]{returnType})) {
            list.add(returnType.cast(object));
        }
        return list;
    }

    public JsonTranslator getTranslator() {
        return this.translator;
    }

    public String getRootUrl() {
        return this.rootUrl;
    }

    public Authorization getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(Authorization authorization) {
        this.authorization = authorization;
    }

    public boolean isIgnoringCertificates() {
        return this.ignoringCertificates;
    }

    public void setIgnoringCertificates(boolean ignoringCertificates) {
        this.ignoringCertificates = ignoringCertificates;
    }

    protected void assertResponse(Response response) {
        this.assertResponse(response.getStatus(), response);
    }

    protected void assertResponse(int status, Response response) {
        HttpStatusCode statusCode = HttpStatusCode.findByCode((int)status);
        if (!statusCode.isSuccess()) {
            String content;
            try {
                content = response == null ? null : (String)response.readEntity(String.class);
            }
            catch (Exception e) {
                content = "<< non-string content >>";
            }
            throw this.buildException(statusCode, content);
        }
    }

    protected ApiException buildException(HttpStatusCode statusCode, String content) {
        int length = content == null ? -1 : content.length();
        String msg = String.format("Unexpected response: %s %s", statusCode.getCode(), statusCode.getReason());
        String[] traits = new String[]{String.format("length:%s", length), String.format("content:%s", content)};
        return ApiException.fromCode((HttpStatusCode)statusCode, (String)msg, (String[])traits);
    }

    protected Map<String, Object> toMap(String ... keyValuePairs) {
        if (keyValuePairs == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String pair : keyValuePairs) {
            int pos;
            int n = pos = pair == null ? -1 : pair.indexOf("=");
            if (pair == null) {
                map.put(null, null);
                continue;
            }
            if (pos < 0) {
                map.put(pair, null);
                continue;
            }
            String key = pair.substring(0, pos);
            String value = pair.substring(pos + 1);
            map.put(key, value);
        }
        return map;
    }

    protected ClientBuilder createClient() {
        ClientBuilder builder = ClientBuilder.newBuilder();
        if (!this.ignoringCertificates) {
            return builder;
        }
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, new SecureRandom());
            return builder.sslContext(sslcontext).hostnameVerifier((s1, s2) -> true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Invocation.Builder builder(String url, Map<String, Object> queryMap, Map<String, Object> headers, String ... acceptedResponseTypes) {
        Client client = this.createClient().build();
        UriBuilder uriBuilder = UriBuilder.fromUri((String)this.getRootUrl()).path(url);
        for (Map.Entry<String, Object> queryParam : queryMap.entrySet()) {
            uriBuilder.queryParam(queryParam.getKey(), new Object[]{queryParam.getValue()});
        }
        WebTarget target = client.target(uriBuilder);
        Invocation.Builder builder = target.request(acceptedResponseTypes);
        if (this.authorization != null) {
            builder.header("Authorization", (Object)this.authorization.getHeaderValue());
        }
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            builder.header(entry.getKey(), entry.getValue());
        }
        return builder;
    }
}

