/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.dev.common;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import org.tiogasolutions.dev.common.StringUtils;

public class DateUtilsFactory {
    private final ZoneId zoneId;

    public DateUtilsFactory(ZoneId zoneId) {
        this.zoneId = zoneId != null ? zoneId : ZoneId.systemDefault();
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public LocalTime currentLocalTime() {
        return LocalTime.now(this.zoneId);
    }

    public LocalDate currentLocalDate() {
        return LocalDate.now(this.zoneId);
    }

    public LocalDateTime currentLocalDateTime() {
        return LocalDateTime.now(this.zoneId);
    }

    public ZonedDateTime currentZonedDateTime() {
        return ZonedDateTime.now(this.zoneId);
    }

    public LocalDate toLocalDate(Object date) {
        if (date == null) {
            return null;
        }
        if (date instanceof LocalDate) {
            return (LocalDate)date;
        }
        if (date instanceof String) {
            return this.toLocalDate((String)date);
        }
        if (date instanceof Long) {
            return this.toLocalDate((Long)date);
        }
        if (date instanceof Date) {
            return this.toLocalDate((Date)date);
        }
        if (date instanceof Calendar) {
            return this.toLocalDate((Calendar)date);
        }
        if (date instanceof LocalDateTime) {
            return this.toLocalDate((LocalDateTime)date);
        }
        if (date instanceof ZonedDateTime) {
            return this.toLocalDate((ZonedDateTime)date);
        }
        String msg = String.format("Cannot convert objects of type %s to LocalDate.", date.getClass().getSimpleName());
        throw new IllegalArgumentException(msg);
    }

    public LocalDate toLocalDate(String date) {
        try {
            return LocalDate.parse(date);
        }
        catch (Exception exception) {
            if (StringUtils.isBlank(date)) {
                return null;
            }
            if ((date = DateUtilsFactory.sanitize(date)).contains("T")) {
                date = date.substring(0, date.indexOf(84));
                return LocalDate.parse(date);
            }
            return LocalDate.parse(date);
        }
    }

    public LocalDate toLocalDate(long date) {
        if (date == 0L) {
            return null;
        }
        if (date > 0L) {
            Instant instant = Instant.ofEpochMilli(date);
            return LocalDate.from(instant.atZone(this.zoneId));
        }
        throw new IllegalArgumentException("The value \"date\" must be greater than or equal to zero.");
    }

    public LocalDate toLocalDate(Date date) {
        if (StringUtils.isBlank(date)) {
            return null;
        }
        return LocalDateTime.ofInstant(date.toInstant(), this.zoneId).toLocalDate();
    }

    public LocalDate toLocalDate(Calendar date) {
        if (StringUtils.isBlank(date)) {
            return null;
        }
        return LocalDate.of(date.get(1), date.get(2) + 1, date.get(5));
    }

    public LocalDate toLocalDate(LocalDateTime date) {
        if (StringUtils.isBlank(date)) {
            return null;
        }
        return date.toLocalDate();
    }

    public LocalDate toLocalDate(ZonedDateTime date) {
        if (StringUtils.isBlank(date)) {
            return null;
        }
        return date.toLocalDate();
    }

    public LocalDate toLocalDate(int year, int monthOfYear, int dayOfMonth) {
        return LocalDate.of(year, monthOfYear, dayOfMonth);
    }

    public LocalTime toLocalTime(Object date) {
        if (date == null) {
            return null;
        }
        if (date instanceof LocalTime) {
            return (LocalTime)date;
        }
        if (date instanceof String) {
            return this.toLocalTime((String)date);
        }
        if (date instanceof Long) {
            return this.toLocalTime((Long)date);
        }
        if (date instanceof Date) {
            return this.toLocalTime((Date)date);
        }
        if (date instanceof Calendar) {
            return this.toLocalTime((Calendar)date);
        }
        if (date instanceof LocalDateTime) {
            return this.toLocalTime((LocalDateTime)date);
        }
        if (date instanceof ZonedDateTime) {
            return this.toLocalTime((ZonedDateTime)date);
        }
        String msg = String.format("Cannot convert objects of type %s to LocalTime.", date.getClass().getSimpleName());
        throw new IllegalArgumentException(msg);
    }

    public LocalTime toLocalTime(String date) {
        try {
            return LocalTime.parse(date);
        }
        catch (Exception exception) {
            if (date == null) {
                return null;
            }
            if (!(date = DateUtilsFactory.sanitize(date)).contains("-")) {
                return LocalTime.parse(date);
            }
            if (date.contains("T")) {
                LocalDateTime ldt = this.toLocalDateTime(date);
                return ldt.toLocalTime();
            }
            return LocalTime.MIDNIGHT;
        }
    }

    public LocalTime toLocalTime(long date) {
        if (date == 0L) {
            return null;
        }
        if (date > 0L) {
            Instant instant = Instant.ofEpochMilli(date);
            return LocalTime.from(instant.atZone(this.zoneId));
        }
        throw new IllegalArgumentException("The value \"date\" must be greater than or equal to zero.");
    }

    public LocalTime toLocalTime(Date date) {
        if (date == null) {
            return null;
        }
        return this.toLocalTime(date.getTime());
    }

    public LocalTime toLocalTime(Calendar date) {
        if (date == null) {
            return null;
        }
        return LocalTime.of(date.get(11), date.get(12), date.get(13), date.get(14) * 1000 * 1000);
    }

    public LocalTime toLocalTime(LocalDateTime date) {
        if (date == null) {
            return null;
        }
        return date.toLocalTime();
    }

    public LocalTime toLocalTime(ZonedDateTime date) {
        if (date == null) {
            return null;
        }
        return date.toLocalTime();
    }

    public LocalTime toLocalTimeWithMills(int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        return LocalTime.of(hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond * 1000 * 1000);
    }

    public LocalTime toLocalTimeWithNanos(int hourOfDay, int minuteOfHour, int secondOfMinute, int nanoOfSecond) {
        return LocalTime.of(hourOfDay, minuteOfHour, secondOfMinute, nanoOfSecond);
    }

    public LocalDateTime toLocalDateTime(Object date) {
        if (date == null) {
            return null;
        }
        if (date instanceof LocalDateTime) {
            return (LocalDateTime)date;
        }
        if (date instanceof String) {
            return this.toLocalDateTime((String)date);
        }
        if (date instanceof Long) {
            return this.toLocalDateTime((Long)date);
        }
        if (date instanceof Date) {
            return this.toLocalDateTime((Date)date);
        }
        if (date instanceof Calendar) {
            return this.toLocalDateTime((Calendar)date);
        }
        if (date instanceof LocalDate) {
            return this.toLocalDateTime((LocalDate)date);
        }
        if (date instanceof ZonedDateTime) {
            return this.toLocalDateTime((ZonedDateTime)date);
        }
        String msg = String.format("Cannot convert objects of type %s to LocalDateTime.", date.getClass().getSimpleName());
        throw new IllegalArgumentException(msg);
    }

    public LocalDateTime toLocalDateTime(String date) {
        try {
            return LocalDateTime.parse(date);
        }
        catch (Exception exception) {
            int pos;
            int zonePos;
            if (date == null) {
                return null;
            }
            if (!(date = DateUtilsFactory.sanitize(date)).contains("T")) {
                date = date + "T" + LocalTime.MIDNIGHT;
            }
            if ((zonePos = date.indexOf("-", pos = date.indexOf("T"))) >= 0 || date.toUpperCase().endsWith("Z")) {
                return this.toZonedDateTime(date).toLocalDateTime();
            }
            return LocalDateTime.parse(date);
        }
    }

    public LocalDateTime toLocalDateTime(long date) {
        if (date == 0L) {
            return null;
        }
        if (date > 0L) {
            Instant instant = Instant.ofEpochMilli(date);
            return LocalDateTime.from(instant.atZone(this.zoneId));
        }
        throw new IllegalArgumentException("The value \"date\" must be greater than or equal to zero.");
    }

    public LocalDateTime toLocalDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return LocalDateTime.ofInstant(date.toInstant(), this.zoneId);
    }

    public LocalDateTime toLocalDateTime(Calendar date) {
        if (date == null) {
            return null;
        }
        return LocalDateTime.of(date.get(1), date.get(2) + 1, date.get(5), date.get(11), date.get(12), date.get(13), date.get(14) * 1000 * 1000);
    }

    public LocalDateTime toLocalDateTime(LocalDate date) {
        if (date == null) {
            return null;
        }
        return LocalDateTime.of(date, LocalTime.MIDNIGHT);
    }

    public LocalDateTime toLocalDateTime(ZonedDateTime date) {
        if (date == null) {
            return null;
        }
        return date.toLocalDateTime();
    }

    public LocalDateTime toLocalDateTimeWithMills(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        return LocalDateTime.of(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond * 1000 * 1000);
    }

    public LocalDateTime toLocalDateTimeWithNanos(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int nanoOfSecond) {
        return LocalDateTime.of(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, nanoOfSecond);
    }

    public ZonedDateTime toZonedDateTime(Object date) {
        if (date == null) {
            return null;
        }
        if (date instanceof ZonedDateTime) {
            return (ZonedDateTime)date;
        }
        if (date instanceof String) {
            return this.toZonedDateTime((String)date);
        }
        if (date instanceof Long) {
            return this.toZonedDateTime((Long)date);
        }
        if (date instanceof LocalDate) {
            return this.toZonedDateTime((LocalDate)date);
        }
        if (date instanceof LocalDateTime) {
            return this.toZonedDateTime((LocalDateTime)date);
        }
        if (date instanceof Date) {
            return this.toZonedDateTime((Date)date);
        }
        if (date instanceof Calendar) {
            return this.toZonedDateTime((Calendar)date);
        }
        String msg = String.format("Cannot convert objects of type %s to DateTime.", date.getClass().getSimpleName());
        throw new IllegalArgumentException(msg);
    }

    @Deprecated
    public ZonedDateTime toDateTime(String date) {
        return this.toZonedDateTime(date);
    }

    public ZonedDateTime toZonedDateTime(String date) {
        try {
            return ZonedDateTime.parse(date);
        }
        catch (Exception exception) {
            if (date == null) {
                return null;
            }
            int posT = (date = DateUtilsFactory.sanitize(date)).indexOf("T");
            if (posT >= 0) {
                int posZ = date.indexOf("-", posT);
                if (posZ >= 0) {
                    String zone = date.substring(posZ);
                    date = date.substring(0, posZ);
                    date = date + zone;
                    return ZonedDateTime.parse(date);
                }
                if (date.toUpperCase().endsWith("Z")) {
                    LocalDateTime localDateTime = LocalDateTime.parse(date, this.getFormatter(date));
                    ZoneId zoneId = ZoneId.of("Z");
                    ZonedDateTime value = ZonedDateTime.of(localDateTime, zoneId);
                    return value;
                }
                LocalDateTime localDateTime = LocalDateTime.parse(date, this.getFormatter(date));
                return ZonedDateTime.of(localDateTime, this.zoneId);
            }
            LocalDate localDate = LocalDate.parse(date, this.getFormatter(date));
            return ZonedDateTime.of(localDate, LocalTime.MIDNIGHT, this.zoneId);
        }
    }

    private DateTimeFormatter getFormatter(String date) {
        int posT = date.indexOf("T");
        if (posT >= 0) {
            if (date.indexOf("-", posT) >= 0) {
                return DateTimeFormatter.ISO_ZONED_DATE_TIME;
            }
            return DateTimeFormatter.ISO_DATE_TIME;
        }
        if (date.contains(" ") || date.contains("T")) {
            return DateTimeFormatter.ISO_DATE_TIME;
        }
        if (date.contains(":")) {
            return DateTimeFormatter.ISO_LOCAL_TIME;
        }
        return DateTimeFormatter.ISO_LOCAL_DATE;
    }

    @Deprecated
    public ZonedDateTime toDateTime(long date) {
        return this.toZonedDateTime(date);
    }

    public ZonedDateTime toZonedDateTime(long date) {
        if (date == 0L) {
            return null;
        }
        if (date > 0L) {
            Instant instant = Instant.ofEpochMilli(date);
            return ZonedDateTime.from(instant.atZone(this.zoneId));
        }
        throw new IllegalArgumentException("The value \"date\" must be greater than or equal to zero.");
    }

    @Deprecated
    public ZonedDateTime toDateTime(LocalDate date) {
        return this.toZonedDateTime(date);
    }

    public ZonedDateTime toZonedDateTime(LocalDate date) {
        if (date == null) {
            return null;
        }
        return ZonedDateTime.of(date, LocalTime.MIDNIGHT, this.zoneId);
    }

    @Deprecated
    public ZonedDateTime toDateTime(LocalDateTime date) {
        return this.toZonedDateTime(date);
    }

    public ZonedDateTime toZonedDateTime(LocalDateTime date) {
        if (date == null) {
            return null;
        }
        return ZonedDateTime.of(date, this.zoneId);
    }

    @Deprecated
    public ZonedDateTime toDateTime(Date date) {
        return this.toZonedDateTime(date);
    }

    public ZonedDateTime toZonedDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return ZonedDateTime.ofInstant(date.toInstant(), this.zoneId);
    }

    @Deprecated
    public ZonedDateTime toDateTime(Calendar date) {
        return this.toZonedDateTime(date);
    }

    public ZonedDateTime toZonedDateTime(Calendar date) {
        if (date == null) {
            return null;
        }
        return ZonedDateTime.of(date.get(1), date.get(2) + 1, date.get(5), date.get(11), date.get(12), date.get(13), date.get(14) * 1000 * 1000, this.zoneId);
    }

    public ZonedDateTime toZonedDateTimeWithMills(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        return ZonedDateTime.of(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond * 1000 * 1000, this.zoneId);
    }

    public ZonedDateTime toZonedDateTimeWithNanos(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int nanoOfSecond) {
        return ZonedDateTime.of(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, nanoOfSecond, this.zoneId);
    }

    public Date toUtilDate(long date) {
        return date <= 0L ? null : new Date(date);
    }

    public Date toUtilDate(String date) {
        if (StringUtils.isBlank(date)) {
            return null;
        }
        ZonedDateTime zdt = this.toZonedDateTime(date);
        return Date.from(zdt.toInstant());
    }

    public Date toUtilDate(Date date) {
        return date;
    }

    public Date toUtilDate(Calendar date) {
        return date == null ? null : date.getTime();
    }

    public Date toUtilDate(LocalDate date) {
        if (date == null) {
            return null;
        }
        Instant instant = this.toZonedDateTime(date).toInstant();
        return Date.from(instant);
    }

    public Date toUtilDate(LocalDateTime date) {
        if (date == null) {
            return null;
        }
        Instant instant = this.toZonedDateTime(date).toInstant();
        return Date.from(instant);
    }

    public Date toUtilDate(ZonedDateTime date) {
        if (date == null) {
            return null;
        }
        Instant instant = date.toInstant();
        return Date.from(instant);
    }

    public Date toUtilDate(int year, int month, int day) {
        return this.toUtilDate(ZonedDateTime.of(year, month, day, 0, 0, 0, 0, this.zoneId));
    }

    private static String sanitize(String date) {
        int posT = (date = date.replace(' ', 'T')).indexOf(84);
        if (posT < 0) {
            date = date.replace('/', '-');
            return date;
        }
        int posZ = date.indexOf(45, posT);
        if (posZ < 0) {
            date = date.replace('/', '-');
            return date;
        }
        String zone = date.substring(posZ);
        date = date.substring(0, posZ);
        date = date.replace('/', '-');
        return date + zone;
    }

    public String toAbbreviatedMonth(Month month) {
        return month == null ? null : this.toAbbreviatedMonth(month.getValue());
    }

    public String toAbbreviatedMonth(YearMonth yearMonth) {
        return yearMonth == null ? null : this.toAbbreviatedMonth(yearMonth.getMonthValue());
    }

    public String toAbbreviatedMonth(int month) {
        switch (month) {
            case 1: {
                return "Jan";
            }
            case 2: {
                return "Feb";
            }
            case 3: {
                return "Mar";
            }
            case 4: {
                return "Apr";
            }
            case 5: {
                return "May";
            }
            case 6: {
                return "Jun";
            }
            case 7: {
                return "Jul";
            }
            case 8: {
                return "Aug";
            }
            case 9: {
                return "Sep";
            }
            case 10: {
                return "Oct";
            }
            case 11: {
                return "Nov";
            }
            case 12: {
                return "Dec";
            }
        }
        String msg = String.format("The value \"%s\" does not represented a valid month.", month);
        throw new IllegalArgumentException(msg);
    }

    public String toMonthName(Month month) {
        return month == null ? null : this.toMonthName(month.getValue());
    }

    public String toMonthName(YearMonth yearMonth) {
        return yearMonth == null ? null : this.toMonthName(yearMonth.getMonthValue());
    }

    public String toMonthName(int month) {
        switch (month) {
            case 1: {
                return "January";
            }
            case 2: {
                return "February";
            }
            case 3: {
                return "March";
            }
            case 4: {
                return "April";
            }
            case 5: {
                return "May";
            }
            case 6: {
                return "June";
            }
            case 7: {
                return "July";
            }
            case 8: {
                return "August";
            }
            case 9: {
                return "September";
            }
            case 10: {
                return "October";
            }
            case 11: {
                return "November";
            }
            case 12: {
                return "December";
            }
        }
        String msg = String.format("The value \"%s\" does not represented a valid month.", month);
        throw new IllegalArgumentException(msg);
    }

    public YearMonth toYearMonth(LocalDate date) {
        return date == null ? null : YearMonth.of(date.getYear(), date.getMonthValue());
    }

    public YearMonth toYearMonth(LocalDateTime date) {
        return date == null ? null : YearMonth.of(date.getYear(), date.getMonthValue());
    }

    public YearMonth toYearMonth(ZonedDateTime date) {
        return date == null ? null : YearMonth.of(date.getYear(), date.getMonthValue());
    }

    public LocalDate toLastDate(LocalDate date) {
        YearMonth yearMonth = this.toYearMonth(date);
        int lastDayOfMonth = yearMonth.lengthOfMonth();
        return date == null ? null : LocalDate.of(date.getYear(), date.getMonthValue(), lastDayOfMonth);
    }

    public LocalDateTime toLastDate(LocalDateTime date) {
        YearMonth yearMonth = this.toYearMonth(date);
        int lastDayOfMonth = yearMonth.lengthOfMonth();
        return date == null ? null : LocalDateTime.of(date.getYear(), date.getMonthValue(), lastDayOfMonth, date.getHour(), date.getMinute(), date.getSecond(), date.getNano());
    }

    public ZonedDateTime toLastDate(ZonedDateTime date) {
        YearMonth yearMonth = this.toYearMonth(date);
        int lastDayOfMonth = yearMonth.lengthOfMonth();
        return date == null ? null : ZonedDateTime.of(date.getYear(), date.getMonthValue(), lastDayOfMonth, date.getHour(), date.getMinute(), date.getSecond(), date.getNano(), date.getZone());
    }

    public LocalDate toFirstDate(LocalDate date) {
        return date == null ? null : LocalDate.of(date.getYear(), date.getMonthValue(), 1);
    }

    public LocalDateTime toFirstDate(LocalDateTime date) {
        return date == null ? null : LocalDateTime.of(date.getYear(), date.getMonthValue(), 1, date.getHour(), date.getMinute(), date.getSecond(), date.getNano());
    }

    public ZonedDateTime toFirstDate(ZonedDateTime date) {
        return date == null ? null : ZonedDateTime.of(date.getYear(), date.getMonthValue(), 1, date.getHour(), date.getMinute(), date.getSecond(), date.getNano(), date.getZone());
    }
}

