/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.notifier.builder;

import java.util.ArrayList;
import java.util.List;
import org.tiogasolutions.notify.notifier.builder.NotificationBuilder;
import org.tiogasolutions.notify.notifier.builder.NotificationBuilderCallback;
import org.tiogasolutions.notify.notifier.builder.SendNotificationResponseCallback;
import org.tiogasolutions.notify.notifier.send.SendNotificationResponse;

public class NotificationBuilderCallbacks {
    private final List<NotificationBuilderCallback> onBeginCallbacks = new ArrayList<NotificationBuilderCallback>();
    private final List<NotificationBuilderCallback> beforeSendCallbacks = new ArrayList<NotificationBuilderCallback>();
    private final List<SendNotificationResponseCallback> onSuccessCallbacks = new ArrayList<SendNotificationResponseCallback>();
    private final List<SendNotificationResponseCallback> onFailureCallbacks = new ArrayList<SendNotificationResponseCallback>();

    public NotificationBuilderCallbacks() {
    }

    public NotificationBuilderCallbacks(NotificationBuilderCallbacks callbacks) {
        this.onBeginCallbacks.addAll(callbacks.onBeginCallbacks);
        this.beforeSendCallbacks.addAll(callbacks.beforeSendCallbacks);
        this.onSuccessCallbacks.addAll(callbacks.onSuccessCallbacks);
        this.onFailureCallbacks.addAll(callbacks.onFailureCallbacks);
    }

    public NotificationBuilderCallbacks copy() {
        return new NotificationBuilderCallbacks(this);
    }

    public void onBegin(NotificationBuilderCallback callback) {
        this.onBeginCallbacks.add(callback);
    }

    public void onBeforeSend(NotificationBuilderCallback callback) {
        this.beforeSendCallbacks.add(callback);
    }

    public void onSuccess(SendNotificationResponseCallback callback) {
        this.onSuccessCallbacks.add(callback);
    }

    public void onFailure(SendNotificationResponseCallback callback) {
        this.onFailureCallbacks.add(callback);
    }

    public void callBegin(NotificationBuilder builder) {
        this.onBeginCallbacks.forEach(c -> c.call(builder));
    }

    public void callBeforeSend(NotificationBuilder builder) {
        this.beforeSendCallbacks.forEach(c -> c.call(builder));
    }

    public void callOnSuccess(SendNotificationResponse response) {
        this.onSuccessCallbacks.forEach(c -> c.call(response));
    }

    public void callOnFailure(SendNotificationResponse response) {
        this.onFailureCallbacks.forEach(c -> c.call(response));
    }

    protected List<NotificationBuilderCallback> getOnBeginCallbacks() {
        return this.onBeginCallbacks;
    }

    protected List<NotificationBuilderCallback> getBeforeSendCallbacks() {
        return this.beforeSendCallbacks;
    }

    protected List<SendNotificationResponseCallback> getOnSuccessCallbacks() {
        return this.onSuccessCallbacks;
    }

    protected List<SendNotificationResponseCallback> getOnFailureCallbacks() {
        return this.onFailureCallbacks;
    }
}

