/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.pub.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tiogasolutions.dev.common.exceptions.ExceptionUtils;

public class ExceptionInfo {
    private final String exceptionType;
    private final String message;
    private final String stackTrace;
    private final ExceptionInfo cause;

    @JsonCreator
    public ExceptionInfo(@JsonProperty(value="exceptionType") String exceptionType, @JsonProperty(value="message") String message, @JsonProperty(value="stackTrace") String stackTrace, @JsonProperty(value="cause") ExceptionInfo cause) {
        this.exceptionType = exceptionType;
        this.message = message;
        this.stackTrace = stackTrace == null ? null : stackTrace.replace("\r", "");
        this.cause = cause;
    }

    public ExceptionInfo(Throwable throwable) {
        this.exceptionType = throwable.getClass().getName();
        this.message = ExceptionUtils.getMessage((Throwable)throwable);
        this.stackTrace = ExceptionUtils.getStackTrace((Throwable)throwable).replace("\r", "");
        this.cause = throwable.getCause() == null || throwable == throwable.getCause() ? null : new ExceptionInfo(throwable.getCause());
    }

    public String getExceptionType() {
        return this.exceptionType;
    }

    public ExceptionInfo getCause() {
        return this.cause;
    }

    @JsonIgnore
    public List<ExceptionInfo> getCauses() {
        ArrayList<ExceptionInfo> causes = new ArrayList<ExceptionInfo>();
        for (ExceptionInfo source = this.cause; source != null; source = source.getCause()) {
            causes.add(source);
        }
        return Collections.unmodifiableList(causes);
    }

    public String getMessage() {
        return this.message;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExceptionInfo that = (ExceptionInfo)o;
        if (this.cause != null ? !this.cause.equals(that.cause) : that.cause != null) {
            return false;
        }
        if (this.exceptionType != null ? !this.exceptionType.equals(that.exceptionType) : that.exceptionType != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        return !(this.stackTrace != null ? !this.stackTrace.equals(that.stackTrace) : that.stackTrace != null);
    }

    public int hashCode() {
        int result = this.exceptionType != null ? this.exceptionType.hashCode() : 0;
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.stackTrace != null ? this.stackTrace.hashCode() : 0);
        result = 31 * result + (this.cause != null ? this.cause.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ExceptionInfo{exceptionType='" + this.exceptionType + '\'' + ", message='" + this.message + '\'' + '}';
    }
}

