/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.pub.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.time.ZonedDateTime;
import org.tiogasolutions.notify.pub.route.Destination;
import org.tiogasolutions.notify.pub.task.TaskRef;
import org.tiogasolutions.notify.pub.task.TaskResponse;
import org.tiogasolutions.notify.pub.task.TaskStatus;

public class Task {
    private final URI self;
    private final String taskId;
    private final String revision;
    private final TaskStatus taskStatus;
    private final String notificationId;
    private final ZonedDateTime createdAt;
    private final Destination destination;
    private final TaskResponse taskResponse;

    @JsonCreator
    public Task(@JsonProperty(value="self") URI self, @JsonProperty(value="taskId") String taskId, @JsonProperty(value="revision") String revision, @JsonProperty(value="taskStatus") TaskStatus taskStatus, @JsonProperty(value="notificationId") String notificationId, @JsonProperty(value="createdAt") ZonedDateTime createdAt, @JsonProperty(value="destination") Destination destination, @JsonProperty(value="lastResponse") TaskResponse taskResponse) {
        this.self = self;
        this.taskId = taskId;
        this.revision = revision;
        this.notificationId = notificationId;
        this.createdAt = createdAt;
        this.taskStatus = taskStatus;
        this.destination = destination;
        this.taskResponse = taskResponse;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public URI getSelf() {
        return this.self;
    }

    public TaskStatus getTaskStatus() {
        return this.taskStatus;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getNotificationId() {
        return this.notificationId;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public TaskResponse getTaskResponse() {
        return this.taskResponse;
    }

    public TaskRef toTaskRef() {
        return new TaskRef(this.taskId, this.revision, this.notificationId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Task task = (Task)o;
        if (this.createdAt != null ? !this.createdAt.equals(task.createdAt) : task.createdAt != null) {
            return false;
        }
        if (this.destination != null ? !this.destination.equals(task.destination) : task.destination != null) {
            return false;
        }
        if (this.notificationId != null ? !this.notificationId.equals(task.notificationId) : task.notificationId != null) {
            return false;
        }
        if (this.revision != null ? !this.revision.equals(task.revision) : task.revision != null) {
            return false;
        }
        if (this.self != null ? !this.self.equals(task.self) : task.self != null) {
            return false;
        }
        if (this.taskId != null ? !this.taskId.equals(task.taskId) : task.taskId != null) {
            return false;
        }
        if (this.taskResponse != null ? !this.taskResponse.equals(task.taskResponse) : task.taskResponse != null) {
            return false;
        }
        return this.taskStatus == task.taskStatus;
    }

    public int hashCode() {
        int result = this.self != null ? this.self.hashCode() : 0;
        result = 31 * result + (this.taskId != null ? this.taskId.hashCode() : 0);
        result = 31 * result + (this.revision != null ? this.revision.hashCode() : 0);
        result = 31 * result + (this.taskStatus != null ? this.taskStatus.hashCode() : 0);
        result = 31 * result + (this.notificationId != null ? this.notificationId.hashCode() : 0);
        result = 31 * result + (this.createdAt != null ? this.createdAt.hashCode() : 0);
        result = 31 * result + (this.destination != null ? this.destination.hashCode() : 0);
        result = 31 * result + (this.taskResponse != null ? this.taskResponse.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Task{self=" + this.self + ", taskId='" + this.taskId + '\'' + ", revision='" + this.revision + '\'' + ", taskStatus=" + (Object)((Object)this.taskStatus) + ", notificationId='" + this.notificationId + '\'' + ", createdAt=" + this.createdAt + ", destination=" + this.destination + ", taskResponse=" + this.taskResponse + '}';
    }
}

