/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.lib.jaxrs.providers;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.dev.common.net.HttpStatusCode;
import org.tiogasolutions.lib.jaxrs.domain.TiogaExceptionInfo;

public abstract class TiogaJaxRsExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger log = LoggerFactory.getLogger(TiogaJaxRsExceptionMapper.class);
    @Context
    protected UriInfo uriInfo;
    private final Map<Class<?>, Integer> exceptionMap = new HashMap();

    public TiogaJaxRsExceptionMapper() {
        log.info("Created.");
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public Map<Class<?>, Integer> getExceptionMap() {
        return Collections.unmodifiableMap(this.exceptionMap);
    }

    public void registerException(HttpStatusCode httpStatus, Class<?> ... types) {
        this.registerException(httpStatus.getCode(), types);
    }

    public void registerException(int httpStatus, Class<?> ... types) {
        for (Class<?> type : types) {
            this.exceptionMap.put(type, httpStatus);
        }
    }

    public Response toResponse(Throwable ex) {
        WebApplicationException wae;
        if (this.exceptionMap.containsKey(ex.getClass())) {
            int statusCode = this.exceptionMap.get(ex.getClass());
            return this.throwableToResponse(statusCode, ex);
        }
        if (ex instanceof ApiException) {
            ApiException apiEx = (ApiException)ex;
            return this.apiExceptionToResponse(apiEx);
        }
        if (ex instanceof WebApplicationException && (wae = (WebApplicationException)ex).getResponse() != null) {
            return this.webApplicationExceptionToResponse(wae);
        }
        while (ex.getCause() != null && ex.getCause() != ex) {
            if ((ex = ex.getCause()) instanceof ApiException) {
                return this.toResponse(ex);
            }
            if (ex instanceof WebApplicationException) {
                return this.toResponse(ex);
            }
            if (!this.exceptionMap.containsKey(ex.getClass())) continue;
            return this.toResponse(ex);
        }
        return this.throwableToResponse(500, ex);
    }

    protected Response apiExceptionToResponse(ApiException ex) {
        int statusCode = ex.getHttpStatusCode().getCode();
        this.logException((Throwable)ex, statusCode);
        TiogaExceptionInfo exceptionInfo = new TiogaExceptionInfo(ex);
        return this.exceptionInfoToResponse(statusCode, exceptionInfo);
    }

    protected Response webApplicationExceptionToResponse(WebApplicationException ex) {
        int statusCode = ex.getResponse().getStatus();
        this.logException((Throwable)ex, statusCode);
        TiogaExceptionInfo exceptionInfo = new TiogaExceptionInfo(ex);
        return this.exceptionInfoToResponse(statusCode, exceptionInfo);
    }

    protected Response throwableToResponse(int statusCode, Throwable ex) {
        HttpStatusCode hsc = HttpStatusCode.findByCode((int)statusCode);
        this.logException(ex, statusCode);
        TiogaExceptionInfo exceptionInfo = new TiogaExceptionInfo(hsc.getCode(), hsc.getReason());
        return this.exceptionInfoToResponse(statusCode, exceptionInfo);
    }

    protected Response exceptionInfoToResponse(int statusCode, TiogaExceptionInfo exceptionInfo) {
        return Response.status((int)statusCode).entity((Object)exceptionInfo).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    protected void logException(Throwable throwable, int statusCode) {
        String msg = "Status " + statusCode;
        if (this.uriInfo != null) {
            msg = msg + " ";
            msg = msg + this.uriInfo.getRequestUri();
        }
        if (statusCode >= 400 && statusCode < 500) {
            this.log4xxException(msg, throwable, statusCode);
        } else {
            this.log5xxException(msg, throwable, statusCode);
        }
    }

    protected void log4xxException(String msg, Throwable throwable, int statusCode) {
        log.info(msg);
    }

    protected void log5xxException(String msg, Throwable throwable, int statusCode) {
        log.error(msg, throwable);
    }

    public static String cleanUrl(URI uri) {
        if (uri == null) {
            return null;
        }
        if (uri.toASCIIString().toLowerCase().startsWith("http://")) {
            return uri.toASCIIString().substring(7);
        }
        if (uri.toASCIIString().toLowerCase().startsWith("https://")) {
            return uri.toASCIIString().substring(8);
        }
        return uri.toASCIIString();
    }
}

