/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.lib.hal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.tiogasolutions.dev.common.EnvUtils;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.lib.hal.HalCurie;

public class HalLink {
    public static boolean forceHttps = "true".equals(EnvUtils.findProperty((String)"hal_links_force_https", (String)"false"));
    public static int httpsPort = Integer.valueOf(EnvUtils.findProperty((String)"hal_links_https_port", (String)"443"));
    private final URI href;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final String title;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private final boolean templated;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final String deprecation;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final List<HalCurie> curies;
    @JsonIgnore
    private final String name;
    @JsonIgnore
    private final String type;
    @JsonIgnore
    private final URI profile = null;
    @JsonIgnore
    private final String hreflang;

    private HalLink() {
        this.name = null;
        this.type = null;
        this.hreflang = null;
        this.href = null;
        this.title = null;
        this.templated = false;
        this.deprecation = null;
        this.curies = Collections.emptyList();
    }

    @JsonCreator
    protected HalLink(@JsonProperty(value="href") URI href, @JsonProperty(value="title") String title, @JsonProperty(value="templated") boolean templated, @JsonProperty(value="deprecation") String deprecation, @JsonProperty(value="curies") List<HalCurie> curies) {
        this.name = null;
        this.type = null;
        this.hreflang = null;
        if (forceHttps && "http".equals(href.getScheme())) {
            int pos = href.toString().indexOf("/", 8);
            String newUri = "https://";
            if (StringUtils.isNotBlank((Object)href.getUserInfo())) {
                newUri = newUri + href.getUserInfo();
                newUri = newUri + "@";
            }
            newUri = newUri + href.getHost();
            newUri = newUri + ":";
            newUri = newUri + httpsPort;
            String remainder = pos < 0 ? "" : href.toString().substring(pos);
            newUri = newUri + remainder;
            this.href = URI.create(newUri);
        } else {
            this.href = href;
        }
        this.title = title;
        this.templated = templated;
        this.deprecation = deprecation;
        if (curies == null) {
            curies = Collections.emptyList();
        }
        this.curies = Collections.unmodifiableList(curies);
    }

    public URI getHref() {
        return this.href;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isTemplated() {
        return this.templated;
    }

    public String getDeprecation() {
        return this.deprecation;
    }

    public List<HalCurie> getCuries() {
        return this.curies;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public URI getProfile() {
        return this.profile;
    }

    public String getHreflang() {
        return this.hreflang;
    }

    public HalLink deprecation(URI deprecation) {
        return this.deprecation(deprecation.toString());
    }

    public HalLink deprecation(String deprecation) {
        return new HalLink(this.href, this.title, this.templated, deprecation, this.curies);
    }

    public HalLink templated() {
        return new HalLink(this.href, this.title, true, this.deprecation, this.curies);
    }

    public static HalLink create(URI href) {
        return new HalLink(href, null, false, null, null);
    }

    public static HalLink create(String href) {
        URI uri = URI.create(href);
        return new HalLink(uri, null, false, null, null);
    }

    public static HalLink create(URI href, String title) {
        return new HalLink(href, title, false, null, null);
    }

    public static HalLink create(String href, String title) {
        URI uri = URI.create(href);
        return new HalLink(uri, title, false, null, null);
    }
}

