/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.test;

import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.DatatypeConverter;
import org.springframework.context.annotation.Profile;
import org.tiogasolutions.dev.common.BeanUtils;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.notify.kernel.config.CouchServers;
import org.tiogasolutions.notify.kernel.domain.DomainKernel;
import org.tiogasolutions.notify.kernel.execution.ExecutionContext;
import org.tiogasolutions.notify.kernel.notification.CreateNotification;
import org.tiogasolutions.notify.kernel.notification.NotificationEntity;
import org.tiogasolutions.notify.kernel.notification.NotificationKernel;
import org.tiogasolutions.notify.kernel.task.CreateTask;
import org.tiogasolutions.notify.kernel.task.TaskEntity;
import org.tiogasolutions.notify.pub.common.ExceptionInfo;
import org.tiogasolutions.notify.pub.common.Link;
import org.tiogasolutions.notify.pub.domain.DomainProfile;
import org.tiogasolutions.notify.pub.domain.DomainStatus;
import org.tiogasolutions.notify.pub.notification.Notification;
import org.tiogasolutions.notify.pub.notification.NotificationRef;
import org.tiogasolutions.notify.pub.route.DestinationDef;
import org.tiogasolutions.notify.pub.route.RouteCatalog;

@Named
@Profile(value={"test"})
public class TestFactory {
    public static final String API_KEY = "9999";
    public static final String API_PASSWORD = "unittest";
    public static final String DOMAIN_NAME = "kernel-test";
    private final NotificationKernel notificationKernel;

    @Inject
    public TestFactory(CouchServers couchServers, DomainKernel domainKernel, NotificationKernel notificationKernel) {
        try {
            this.notificationKernel = notificationKernel;
            couchServers.deleteDomainDatabases(DOMAIN_NAME);
            domainKernel.recreateDomain(DOMAIN_NAME, API_KEY, API_PASSWORD);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public TaskEntity newEmailTaskEntity(Notification notification) {
        DestinationDef destinationDef = new DestinationDef("local", "push").addArg("type", (Object)"emailMsg").addArg("recipient", (Object)"test@jacobparr.com");
        CreateTask create = CreateTask.create(notification.toNotificationRef(), destinationDef.toDestination());
        return this.notificationKernel.createTask(create, notification);
    }

    public NotificationRef newNotificationRef(CreateNotification create) {
        return this.notificationKernel.createNotification(create);
    }

    public DomainProfile newDomainProfile() {
        return new DomainProfile("777", "r-3", "TestDomain", DomainStatus.ACTIVE, "some-api-key", "some-api-passowrd", "notification-db", "request-db", new RouteCatalog(Collections.emptyList(), Collections.emptyList()));
    }

    public Notification newNotification(CreateNotification create) {
        NotificationRef notificationRef = this.notificationKernel.createNotification(create);
        return this.notificationKernel.findNotificationById(notificationRef.getNotificationId());
    }

    public NotificationEntity newNotification(ExecutionContext execContext, CreateNotification create) {
        return NotificationEntity.newEntity(execContext.getDomainName(), create);
    }

    public List<Link> newLinks() {
        return Collections.singletonList(new Link("example", "http://example.com"));
    }

    public CreateNotification newCreateNotificationWithException() {
        return new CreateNotification("test-topic", "This is a test of the emergency broadcast system... this is only a test.", "tracking-id-123", ZonedDateTime.now(), this.newExceptionInfo(), this.newLinks(), BeanUtils.toMap((String[])new String[]{"color:red", "sex:male", "test"}));
    }

    public CreateNotification newCreateNotificationNoException() {
        return new CreateNotification("test-topic", "This is a test of the emergency broadcast system... this is only a test.", "tracking-id-123", ZonedDateTime.now(), null, this.newLinks(), BeanUtils.toMap((String[])new String[]{"color:red", "sex:male", "test"}));
    }

    public ExceptionInfo newExceptionInfo() {
        return new ExceptionInfo((Throwable)ApiException.forbidden((String)"I'm sorry, I cannot let you do that.", (Throwable)new RuntimeException("I tripped when I was running with scissors"), (String[])new String[0]));
    }

    public String toHttpAuth(String username, String password) {
        byte[] value = (username + ":" + password).getBytes();
        return "Basic " + DatatypeConverter.printBase64Binary((byte[])value);
    }
}

