/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.message;

import org.tiogasolutions.dev.common.StringUtils;

public class HtmlMessage {
    private final String html;
    private final String subject;
    private final String body;

    public HtmlMessage(String html) {
        this.html = html;
        this.body = this.extractBody(html);
        this.subject = this.extractSubject(html);
    }

    public String getHtml() {
        return this.html;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getBody() {
        return this.body;
    }

    public String extractBody(String htmlContent) {
        String html = StringUtils.getTagContents((Object)htmlContent, (String)"html", (int)0);
        return StringUtils.getTagContents((Object)html, (String)"body", (int)0);
    }

    public String extractSubject(String htmlContent) {
        String html = StringUtils.getTagContents((Object)htmlContent, (String)"html", (int)0);
        String head = StringUtils.getTagContents((Object)html, (String)"head", (int)0);
        return StringUtils.getTagContents((Object)head, (String)"title", (int)0);
    }
}

