/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.notification;

import java.time.ZoneId;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.dev.common.exceptions.ApiNotFoundException;
import org.tiogasolutions.dev.domain.query.QueryResult;
import org.tiogasolutions.notify.kernel.domain.DomainKernel;
import org.tiogasolutions.notify.kernel.execution.ExecutionAccessor;
import org.tiogasolutions.notify.kernel.execution.ExecutionContext;
import org.tiogasolutions.notify.kernel.notification.CreateAttachment;
import org.tiogasolutions.notify.kernel.notification.CreateNotification;
import org.tiogasolutions.notify.kernel.notification.NotificationDomain;
import org.tiogasolutions.notify.kernel.task.CreateTask;
import org.tiogasolutions.notify.kernel.task.TaskEntity;
import org.tiogasolutions.notify.pub.attachment.AttachmentHolder;
import org.tiogasolutions.notify.pub.attachment.AttachmentQuery;
import org.tiogasolutions.notify.pub.notification.Notification;
import org.tiogasolutions.notify.pub.notification.NotificationQuery;
import org.tiogasolutions.notify.pub.notification.NotificationRef;
import org.tiogasolutions.notify.pub.task.TaskQuery;

@Named
public class NotificationKernel {
    private static Logger log = LoggerFactory.getLogger(NotificationKernel.class);
    private final ExecutionAccessor executionAccessor;
    private final DomainKernel domainKernel;

    @Inject
    public NotificationKernel(ExecutionAccessor executionAccessor, DomainKernel domainKernel) {
        log.info("Default zoneId: " + ZoneId.systemDefault());
        this.executionAccessor = executionAccessor;
        this.domainKernel = domainKernel;
    }

    public NotificationRef createNotification(CreateNotification create) {
        return this.domain().createNotification(create);
    }

    public NotificationRef createAttachment(CreateAttachment create) {
        return this.domain().createAttachment(create);
    }

    public QueryResult<Notification> query(NotificationQuery query) {
        return this.domain().query(query);
    }

    public Notification findNotificationById(String notificationId) throws ApiNotFoundException {
        return this.domain().findNotificationById(notificationId).toNotification();
    }

    public AttachmentHolder query(AttachmentQuery query) {
        return this.domain().findAttachment(query.getNotificationId(), query.getAttachmentName());
    }

    public void deleteNotification(String notificationId) {
        this.domain().deleteNotification(notificationId);
    }

    public QueryResult<TaskEntity> query(TaskQuery query) {
        return this.domain().query(query);
    }

    public TaskEntity findTaskById(String taskId) throws ApiNotFoundException {
        return this.domain().findTaskById(taskId);
    }

    public TaskEntity createTask(CreateTask create, Notification notification) {
        return this.domain().createTask(create, notification);
    }

    public TaskEntity saveAndReload(TaskEntity taskEntity) {
        return this.domain().saveAndReload(taskEntity);
    }

    public void deleteTask(String taskId) {
        this.domain().deleteTask(taskId);
    }

    protected NotificationDomain domain() {
        ExecutionContext ec = this.executionAccessor.context();
        return this.domainKernel.notificationDomain(ec);
    }

    public void readAttachment(String notificationId, String attachmentName) {
    }
}

