/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.common;

import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.couchace.core.api.response.CouchResponse;
import org.tiogasolutions.couchace.core.api.response.GetAttachmentResponse;
import org.tiogasolutions.couchace.core.api.response.GetEntityResponse;
import org.tiogasolutions.dev.common.exceptions.ApiConflictException;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.dev.common.exceptions.ApiNotFoundException;

public class AbstractStore {
    protected static final String CREATE_ENTITY_ERROR = "Error creating %s with id %s";
    protected static final String SAVE_ENTITY_ERROR = "Error saving %s with id %s";
    protected static final String DELETE_ENTITY_ERROR = "Error deleting %s with id %s";
    protected static final String FIND_ENTITY_ERROR = "Error finding %s with id %s";
    protected static final String NOT_FOUND_ERROR = "%s not found with id %s";
    protected final CouchDatabase couchDatabase;

    public AbstractStore(CouchDatabase couchDatabase) {
        this.couchDatabase = couchDatabase;
    }

    protected final void throwError(CouchResponse response, String message) {
        if (response.isNotFound()) {
            throw ApiNotFoundException.notFound((String)message, (String[])new String[0]);
        }
        if (response.isConflict()) {
            throw ApiConflictException.conflict((String)message, (String[])new String[0]);
        }
        message = String.format("%s: %s", message, response.getErrorReason()).trim();
        throw ApiException.internalServerError((String)message, (String[])new String[0]);
    }

    protected final void throwIfNotFound(GetEntityResponse response, String message) {
        if (response.isEmpty() || response.isNotFound()) {
            throw ApiNotFoundException.notFound((String)message, (String[])new String[0]);
        }
    }

    protected final void throwIfNotFound(GetAttachmentResponse response, String message) {
        if (response.isEmpty() || response.isNotFound()) {
            throw ApiNotFoundException.notFound((String)message, (String[])new String[0]);
        }
    }
}

