/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.event;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.stereotype.Component;
import org.tiogasolutions.notify.kernel.event.RequestEventListener;
import org.tiogasolutions.notify.kernel.event.TaskEventListener;
import org.tiogasolutions.notify.kernel.request.NotificationRequestEntity;
import org.tiogasolutions.notify.kernel.task.TaskEntity;
import org.tiogasolutions.notify.pub.notification.Notification;

@Component
public class EventBus {
    private List<TaskEventListener> taskEventListeners = new CopyOnWriteArrayList<TaskEventListener>();
    private List<RequestEventListener> requestEventListener = new CopyOnWriteArrayList<RequestEventListener>();

    private EventBus() {
    }

    public void subscribe(TaskEventListener listener) {
        this.taskEventListeners.add(listener);
    }

    public void subscribe(RequestEventListener listener) {
        this.requestEventListener.add(listener);
    }

    public void taskCreated(String domainName, TaskEntity task, Notification notification) {
        this.taskEventListeners.forEach(listener -> listener.taskCreated(domainName, task, notification));
    }

    public void requestCreated(String domainName, NotificationRequestEntity request) {
        this.requestEventListener.forEach(listener -> listener.requestCreated(domainName, request));
    }
}

