/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.request;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.couchace.core.api.http.CouchMediaType;
import org.tiogasolutions.couchace.core.api.query.CouchViewQuery;
import org.tiogasolutions.couchace.core.api.response.CouchResponse;
import org.tiogasolutions.couchace.core.api.response.GetAttachmentResponse;
import org.tiogasolutions.couchace.core.api.response.GetEntityResponse;
import org.tiogasolutions.couchace.core.api.response.WriteResponse;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.notify.kernel.request.NotificationRequestEntity;
import org.tiogasolutions.notify.kernel.request.RequestCouchView;
import org.tiogasolutions.notify.pub.attachment.AttachmentHolder;
import org.tiogasolutions.notify.pub.request.NotificationRequestStatus;

public class NotificationRequestStore {
    private final CouchDatabase couchDatabase;

    @Autowired
    public NotificationRequestStore(CouchDatabase couchDatabase) {
        this.couchDatabase = couchDatabase;
    }

    public CouchDatabase getCouchDatabase() {
        return this.couchDatabase;
    }

    public WriteResponse save(NotificationRequestEntity notificationRequestEntity) {
        return this.couchDatabase.put().entity((Object)notificationRequestEntity).execute();
    }

    public NotificationRequestEntity saveAndReload(NotificationRequestEntity notificationRequestEntity) {
        this.couchDatabase.put().entity((Object)notificationRequestEntity).onError(r -> this.throwError(r, "Error saving NotificationRequest by request id " + notificationRequestEntity.getRequestId())).execute();
        return this.findByRequestId(notificationRequestEntity.getRequestId());
    }

    public WriteResponse addAttachment(String documentId, String revision, AttachmentHolder attachment) {
        CouchMediaType mediaType = CouchMediaType.fromString((String)attachment.getContentType());
        return this.couchDatabase.put().attachment(documentId, revision, attachment.getName(), mediaType, (Object)attachment.getInputStream()).onError(r -> this.throwError(r, String.format("Failure storing notification attachment in couch [%s] - %s", r.getHttpStatus(), r.getErrorReason()))).execute();
    }

    public AttachmentHolder findAttachment(String requestId, String attachmentName) {
        GetAttachmentResponse attachmentResponse = this.couchDatabase.get().attachment(requestId, attachmentName).onError(r -> this.throwError(r, "Error finding NotificationRequest by request id " + requestId)).onResponse(r -> this.throwIfNotFound((GetAttachmentResponse)r, "NotificationRequest not found by request id " + requestId)).execute();
        byte[] content = attachmentResponse.getContent() instanceof byte[] ? (byte[])attachmentResponse.getContent() : attachmentResponse.getStringContent().getBytes();
        return new AttachmentHolder(attachmentName, attachmentResponse.getContentType().getMediaString(), content);
    }

    public NotificationRequestEntity findByRequestId(String requestId) {
        GetEntityResponse getResponse = this.couchDatabase.get().entity(NotificationRequestEntity.class, requestId).onError(r -> this.throwError(r, "Error finding NotificationRequest by request id " + requestId)).onResponse(r -> this.throwIfNotFound((GetEntityResponse)r, "NotificationRequest not found by request id " + requestId)).execute();
        return (NotificationRequestEntity)getResponse.getFirstEntity();
    }

    public NotificationRequestEntity findByTrackingId(String trackingId) {
        CouchViewQuery viewQuery = CouchViewQuery.builder((String)"NotificationRequest", (String)RequestCouchView.ByTrackingId.name()).key(new Object[]{trackingId}).build();
        GetEntityResponse getResponse = this.couchDatabase.get().entity(NotificationRequestEntity.class, viewQuery).onError(r -> this.throwError(r, "Error finding NotificationRequest by tracking id " + trackingId)).onResponse(r -> this.throwIfNotFound((GetEntityResponse)r, "NotificationRequest not found by tracking id " + trackingId)).execute();
        return (NotificationRequestEntity)getResponse.getFirstEntity();
    }

    public List<NotificationRequestEntity> findByStatus(NotificationRequestStatus status) {
        CouchViewQuery.CouchViewQueryBuilder builder;
        if (status == null) {
            builder = CouchViewQuery.builder((String)"Entity", (String)"byEntityType");
            builder.key(new Object[]{"NotificationRequest"});
        } else {
            builder = CouchViewQuery.builder((String)"NotificationRequest", (String)RequestCouchView.ByRequestStatusAndCreatedAt.name());
            builder.start(new Object[]{status, null});
            builder.end(new Object[]{status, "Z"});
        }
        CouchViewQuery viewQuery = builder.build();
        GetEntityResponse getResponse = this.couchDatabase.get().entity(NotificationRequestEntity.class, viewQuery).onError(r -> this.throwError(r, "Error finding " + status + " requests")).execute();
        return getResponse.getEntityList();
    }

    public void deleteRequest(String requestId) {
        if (requestId == null) {
            throw new NullPointerException("The value \"requestId\" cannot be null.");
        }
        NotificationRequestEntity request = this.findByRequestId(requestId);
        this.couchDatabase.delete().document(request.getRequestId(), request.getRevision()).onError(r -> this.throwError(r, String.format("Error deleting %s with id %s", NotificationRequestEntity.class, request.getRequestId()))).execute();
    }

    private void throwError(CouchResponse response, String message) {
        String msg = String.format("%s: %s", message, response.getErrorReason());
        throw ApiException.internalServerError((String)msg, (String[])new String[0]);
    }

    private void throwIfNotFound(GetEntityResponse response, String message) {
        if (response.isEmpty() || response.isNotFound()) {
            throw ApiException.notFound((String)message, (String[])new String[0]);
        }
    }

    private void throwIfNotFound(GetAttachmentResponse response, String message) {
        if (response.isEmpty() || response.isNotFound()) {
            throw ApiException.notFound((String)message, (String[])new String[0]);
        }
    }
}

