/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.domain;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.dev.common.exceptions.ApiNotFoundException;
import org.tiogasolutions.dev.common.id.IdGenerator;
import org.tiogasolutions.notify.kernel.domain.DomainProfileEntity;
import org.tiogasolutions.notify.kernel.domain.DomainStore;
import org.tiogasolutions.notify.kernel.event.EventBus;
import org.tiogasolutions.notify.kernel.execution.ExecutionContext;
import org.tiogasolutions.notify.kernel.notification.NotificationDomain;
import org.tiogasolutions.notify.kernel.task.TaskGenerator;
import org.tiogasolutions.notify.pub.domain.DomainProfile;
import org.tiogasolutions.notify.pub.domain.DomainStatus;
import org.tiogasolutions.notify.pub.domain.DomainSummary;
import org.tiogasolutions.notify.pub.route.RouteCatalog;

@Component
public class DomainKernel {
    private static final String DEFAULT_PASSWORD = "GoFish";
    private final DomainStore domainStore;
    private final IdGenerator domainKeyGenerator;
    private final Map<String, DomainProfile> domainProfileMap = new HashMap<String, DomainProfile>();
    private final DomainProfile systemDomain;
    private final TaskGenerator taskGenerator;
    private final EventBus eventBus;

    @Autowired
    public DomainKernel(DomainStore domainStore, @Qualifier(value="DomainKeyGenerator") IdGenerator idGenerator, TaskGenerator taskGenerator, EventBus eventBus) {
        this.domainStore = domainStore;
        this.domainKeyGenerator = idGenerator;
        this.taskGenerator = taskGenerator;
        this.eventBus = eventBus;
        RouteCatalog routeCatalog = new RouteCatalog(null, null);
        this.systemDomain = new DomainProfile("0000000000", null, "system", DomainStatus.ACTIVE, null, null, null, null, routeCatalog);
        for (DomainProfileEntity domainProfileEntity : domainStore.queryAll()) {
            DomainProfile domainProfile = domainProfileEntity.toModel();
            this.domainProfileMap.put(domainProfile.getApiKey(), domainProfile);
        }
    }

    public boolean hasDomain(String domainName) {
        for (DomainProfile profile : this.domainProfileMap.values()) {
            if (!profile.getDomainName().equalsIgnoreCase(domainName)) continue;
            return true;
        }
        return false;
    }

    public DomainProfile getOrCreateDomain(String domainName) {
        if (this.hasDomain(domainName)) {
            return this.findByDomainName(domainName);
        }
        return this.createDomain(domainName);
    }

    public DomainProfile findByApiKey(String apiKey) {
        DomainProfile profile = this.domainProfileMap.get(apiKey);
        if (profile == null) {
            throw ApiNotFoundException.notFound((String)("Domain not found with api key: " + apiKey), (String[])new String[0]);
        }
        return profile;
    }

    public DomainProfile findByDomainName(String domainName) {
        for (DomainProfile profile : this.domainProfileMap.values()) {
            if (!profile.getDomainName().equalsIgnoreCase(domainName)) continue;
            return profile;
        }
        throw ApiNotFoundException.notFound((String)"The specified domain name was not found.", (String[])new String[0]);
    }

    public List<DomainProfile> listActiveDomainProfiles() {
        return this.domainProfileMap.values().stream().filter(d -> d.getDomainStatus() == DomainStatus.ACTIVE).collect(Collectors.toList());
    }

    public List<NotificationDomain> listActiveNotificationDomains() {
        return this.domainProfileMap.values().stream().filter(d -> d.getDomainStatus() == DomainStatus.ACTIVE).map(this::notificationDomain).collect(Collectors.toList());
    }

    public DomainProfile getSystemDomain() {
        return this.systemDomain;
    }

    public DomainProfile createDomain(String domainName) {
        DomainProfile domainProfile = this.domainStore.createDomain(domainName, this.domainKeyGenerator.newId(), DEFAULT_PASSWORD).toModel();
        this.domainProfileMap.put(domainProfile.getApiKey(), domainProfile);
        return domainProfile;
    }

    public void recreateDomain(String domainName, String apiKey, String password) {
        DomainProfile domainProfile = this.domainStore.recreateDomain(domainName, apiKey, password);
        this.domainProfileMap.put(domainProfile.getApiKey(), domainProfile);
    }

    public void deleteDomain(String domainName) {
        DomainProfileEntity domainProfile = this.domainStore.findByDomainName(domainName);
        this.domainStore.deleteDomain(domainProfile);
        this.domainProfileMap.remove(domainProfile.getApiKey());
    }

    public DomainProfile updateRouteCatalog(DomainProfile domainProfile, RouteCatalog routeCatalog) {
        DomainProfileEntity domainProfileEntity = this.domainStore.findByDomainName(domainProfile.getDomainName());
        domainProfileEntity.setRouteCatalog(routeCatalog);
        domainProfileEntity = this.domainStore.save(domainProfileEntity);
        domainProfile = domainProfileEntity.toModel();
        this.domainProfileMap.put(domainProfile.getApiKey(), domainProfileEntity.toModel());
        return domainProfile;
    }

    public DomainSummary fetchSummary(String domainName) {
        return this.domainStore.fetchSummary(domainName);
    }

    public NotificationDomain notificationDomain(ExecutionContext ec) {
        DomainProfile domainProfile = this.findByApiKey(ec.getApiKey());
        CouchDatabase notificationDatabase = this.domainStore.notificationDb(domainProfile);
        return new NotificationDomain(ec.getDomainName(), notificationDatabase, domainProfile.getRouteCatalog(), this.taskGenerator, this.eventBus);
    }

    public NotificationDomain notificationDomain(String domainName) {
        DomainProfile domainProfile = this.findByDomainName(domainName);
        CouchDatabase notificationDatabase = this.domainStore.notificationDb(domainProfile);
        return new NotificationDomain(domainName, notificationDatabase, domainProfile.getRouteCatalog(), this.taskGenerator, this.eventBus);
    }

    public NotificationDomain notificationDomain(DomainProfile domainProfile) {
        CouchDatabase notificationDatabase = this.domainStore.notificationDb(domainProfile);
        return new NotificationDomain(domainProfile.getDomainName(), notificationDatabase, domainProfile.getRouteCatalog(), this.taskGenerator, this.eventBus);
    }

    public CouchDatabase requestDb(DomainProfile domainProfile) {
        return this.domainStore.requestDb(domainProfile);
    }
}

