/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.message;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.tiogasolutions.notify.pub.attachment.AttachmentInfo;
import org.tiogasolutions.notify.pub.common.ExceptionInfo;
import org.tiogasolutions.notify.pub.domain.DomainProfile;
import org.tiogasolutions.notify.pub.domain.DomainStatus;
import org.tiogasolutions.notify.pub.notification.Notification;
import org.tiogasolutions.notify.pub.route.RouteCatalog;
import org.tiogasolutions.notify.pub.task.Task;

public class MessageModel {
    private final String destinationName;
    private final Map<String, String> destinationMap;
    private final String self;
    private final String notificationId;
    private final String revision;
    private final String topic;
    private final String summary;
    private final String cc;
    private final String trackingId;
    private final ZonedDateTime createdAt;
    private final Map<String, String> traitMap;
    private final List<AttachmentInfo> attachments;
    private final ExceptionInfo exception;
    private final List<ExceptionInfo> causes;
    private final String profileId;
    private final String domainName;
    private final DomainStatus domainStatus;
    private final String apiKey;
    private final String apiPassword;
    private final String notificationDbName;
    private final String requestDbName;
    private final RouteCatalog routeCatalog;

    public MessageModel(DomainProfile domainProfile, Notification notification, Task task) {
        this.destinationName = task.getDestination().getName();
        this.destinationMap = task.getDestination().getArguments();
        this.cc = this.destinationMap.get("cc");
        this.self = notification.getSelf() == null ? null : notification.getSelf().toASCIIString();
        this.notificationId = notification.getNotificationId();
        this.revision = notification.getRevision();
        this.topic = notification.getTopic();
        this.summary = notification.getSummary();
        this.trackingId = notification.getTrackingId();
        this.attachments = notification.getAttachmentInfoList();
        this.exception = notification.getExceptionInfo();
        this.causes = this.exception == null ? Collections.emptyList() : Collections.unmodifiableList(this.exception.getCauses());
        this.traitMap = notification.getTraitMap();
        ZoneId zoneId = ZoneId.systemDefault();
        this.createdAt = notification.getCreatedAt().withZoneSameInstant(zoneId);
        this.profileId = domainProfile.getProfileId();
        this.domainName = domainProfile.getDomainName();
        this.domainStatus = domainProfile.getDomainStatus();
        this.apiKey = domainProfile.getApiKey();
        this.apiPassword = domainProfile.getApiPassword();
        this.notificationDbName = domainProfile.getNotificationDbName();
        this.requestDbName = domainProfile.getRequestDbName();
        this.routeCatalog = domainProfile.getRouteCatalog();
    }

    public String getCc() {
        return this.cc;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public Map<String, String> getDestinationMap() {
        return this.destinationMap;
    }

    public List<ExceptionInfo> getCauses() {
        return this.causes;
    }

    public String getSelf() {
        return this.self;
    }

    public String getNotificationId() {
        return this.notificationId;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public List<AttachmentInfo> getAttachments() {
        return this.attachments;
    }

    public ExceptionInfo getExceptionInfo() {
        return this.exception;
    }

    public Map<String, String> getTraitMap() {
        return this.traitMap;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public DomainStatus getDomainStatus() {
        return this.domainStatus;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiPassword() {
        return this.apiPassword;
    }

    public String getNotificationDbName() {
        return this.notificationDbName;
    }

    public String getRequestDbName() {
        return this.requestDbName;
    }

    public RouteCatalog getRouteCatalog() {
        return this.routeCatalog;
    }

    public static class Trait {
        private final String key;
        private final String value;

        public Trait(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

