/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.kernel.route;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.notify.kernel.route.RouteEvaluator;
import org.tiogasolutions.notify.notifier.Notifier;
import org.tiogasolutions.notify.pub.notification.Notification;
import org.tiogasolutions.notify.pub.route.Destination;
import org.tiogasolutions.notify.pub.route.Route;
import org.tiogasolutions.notify.pub.route.RouteCatalog;

public class JsRouteEvaluator
implements RouteEvaluator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<RouteMatcher> routeMatcherList;
    private final ScriptEngine engine;
    private final Invocable invocable;
    private final Notifier notifier;

    public JsRouteEvaluator(RouteCatalog routeCatalog, Notifier notifier) {
        List routes = routeCatalog.loadActiveRoutes();
        this.notifier = notifier;
        this.routeMatcherList = new ArrayList<RouteMatcher>();
        ScriptEngineManager engineManager = new ScriptEngineManager();
        this.engine = engineManager.getEngineByName("nashorn");
        this.invocable = (Invocable)((Object)this.engine);
        this.routeMatcherList.addAll(routes.stream().map(x$0 -> new RouteMatcher((Route)x$0)).collect(Collectors.toList()));
    }

    @Override
    public Set<Destination> findDestinations(Notification notification) {
        HashSet<Destination> destinations = new HashSet<Destination>();
        this.routeMatcherList.stream().filter(matcher -> matcher.isMatch(notification)).forEach(matcher -> destinations.addAll(((RouteMatcher)matcher).route.getDestinations()));
        return destinations;
    }

    public class RouteMatcher {
        private final Route route;
        private final String jsFunc;

        public RouteMatcher(Route route) {
            this.route = route;
            this.jsFunc = String.format("var eval = %s", route.getEval());
        }

        public boolean isMatch(Notification notification) {
            try {
                JsRouteEvaluator.this.engine.eval(this.jsFunc);
                return (Boolean)JsRouteEvaluator.this.invocable.invokeFunction("eval", notification);
            }
            catch (Exception e) {
                this.notify(notification, e, String.format("Exception testing match (domain=%s, notification=%s, route=%s)", notification.getDomainName(), notification.getNotificationId(), this.route.getName()));
                return false;
            }
        }

        private void notify(Notification notification, Exception e, String msg) {
            try {
                if (notification != null && notification.isInternalException()) {
                    JsRouteEvaluator.this.log.error("SUPPRESSED: " + msg, (Throwable)e);
                } else {
                    JsRouteEvaluator.this.notifier.begin().summary(msg).exception((Throwable)e).send().get();
                }
            }
            catch (Exception ex) {
                JsRouteEvaluator.this.log.error("Exception sending notification", (Throwable)ex);
            }
        }
    }
}

